/**
 * 将字符串转换成蛇形命名规则 [snake case](https://en.wikipedia.org/wiki/Snake_case).
 * @since 1.0.0
 * @Catalog String
 * @param [str=''] (string): 待转的字符
 * @returns (string): 蛇形命名规则字符，例如 `foo_bar`
 * @example
 * _.snakeCase('Foo Bar');
 * // => 'foo_bar'
 *
 * _.snakeCase('fooBar');
 * // => 'foo_bar'
 *
 * _.snakeCase('--FOO-BAR--');
 * // => 'foo_bar'
 *
 */
declare function snakeCase(str?: any): string;
export default snakeCase;
