"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,s){void 0===s&&(s=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,r)}:function(e,t,a,s){void 0===s&&(s=a),e[s]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&__createBinding(t,e,a);return __setModuleDefault(t,e),t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.build=exports.writeWatchCache=void 0;const fs_1=__importDefault(require("fs")),fse=__importStar(require("fs-extra")),os_1=__importDefault(require("os")),path=__importStar(require("path")),rollup_1=require("rollup"),arkts_base_log_1=require("./log/arkts-base-log"),build_event_1=require("./util/build-event"),constants_1=require("./util/constants"),pack_1=require("./util/msgpack/pack"),struct_1=require("./util/msgpack/struct");(0,struct_1.updateReadStruct)();const logger=arkts_base_log_1.ArktsBaseLogger.getLogger("build"),extensionSet=new Set([".ets",".ts","js",".mjs",".cjs"]);let triggerTsWatch,watchParentPort,watchCache,watchEnableFileSystemCache,watchCacheDirectory,lastWatchRes,tsWatchEnd=!1,rollupWatchEnd=!1,isWatchFirst=!0;const lastReUsedFiles=new Set;function readWatchLogs(e){let t=[];const a=path.resolve(e??"",constants_1.DEFAULT_WATCH_LOGS_FILE);if(fs_1.default.existsSync(a))try{t=JSON.parse(fs_1.default.readFileSync(a).toString())}catch(e){logger.debug(`read watch logs failed ${e.message}`)}return t}function writeWatchLogs(){const e=path.resolve(watchCacheDirectory??"",constants_1.DEFAULT_WATCH_LOGS_FILE);try{fse.ensureFileSync(e),fs_1.default.writeFileSync(e,JSON.stringify(arkts_base_log_1.ArktsBaseLogger.getLastLogEvents()))}catch(e){logger.debug(`write watch logs failed ${e.message}`)}}function removeWatchLogs(){const e=path.resolve(watchCacheDirectory??"",constants_1.DEFAULT_WATCH_LOGS_FILE);fs_1.default.rmSync(e,{force:!0})}function writeWatchCache(){lastWatchRes?(writeCache(watchEnableFileSystemCache,watchCache,watchCacheDirectory),writeWatchLogs()):(removeCache(watchCacheDirectory),removeWatchLogs()),watchCache=void 0,watchEnableFileSystemCache=void 0,watchCacheDirectory=void 0}async function build(e,t,a,s,r,c){const n=e.startEvent("read build package cache");readCache(e),e.endEvent(n);const o=!!e.disableGenerateBundle,i=void 0===e.writeBundle||e.writeBundle,l=e.enableFileSystemCache,h=e.cacheDirectory,g=e.watchMode??"false",u=e.unsupportedChangedFiles??[];if(deleteOptions(e),"true"===g){const n=e.startEvent(constants_1.ROLLUP_EVENT_NAME),o=await startWatch(e,t,a,s,r,l,h,u,c);return e.endEvent(n),o}const d=e.startEvent(constants_1.ROLLUP_EVENT_NAME),_=await(0,rollup_1.rollup)(e);if(e.endEvent(d),!o)for(const t of e.output)i?await _.write(t):await _.generate(t);const f=e.startEvent("write build package cache");writeCache(l,_.cache,h),e.endEvent(f);const p=e.startEvent("wait for plug-in registration asynchronous task to complete");if(await _.close(),await _.triggerBundleEnd(),e.endEvent(p),arkts_base_log_1.ArktsBaseLogger.reset(),_.getTimings)return _.getTimings()}function deleteOptions(e){delete e.disableGenerateBundle,delete e.writeBundle,delete e.enableFileSystemCache,delete e.cacheDirectory,delete e.watchMode,delete e.unsupportedChangedFiles}function clearWatchData(){triggerTsWatch=!1,tsWatchEnd=!1,rollupWatchEnd=!1,arkts_base_log_1.ArktsBaseLogger.clearLogEvents(),lastReUsedFiles.clear()}function sendWatchResult(){isWatchFirst=!1,arkts_base_log_1.ArktsBaseLogger.sendLastLogEvents(lastReUsedFiles),lastWatchRes=!arkts_base_log_1.ArktsBaseLogger.checkLoggerHaveErrorInfo(),watchParentPort?.postMessage({type:build_event_1.WatchEvent.WATCH_RESULT,content:lastWatchRes}),clearWatchData()}function processTsWatchEnd(){tsWatchEnd=!0,rollupWatchEnd&&sendWatchResult()}function processRollupWatchEnd(){rollupWatchEnd=!0,!tsWatchEnd&&triggerTsWatch||sendWatchResult()}function updateLastReUsedFiles(e){e.forEach((e=>lastReUsedFiles.add("Windows_NT"===os_1.default.type()?path.posix.join(...e.split(path.sep)):e)))}async function startWatch(e,t,a,s,r,c,n,o,i){return arkts_base_log_1.ArktsBaseLogger.addLastLogEvents(readWatchLogs(n)),arkts_base_log_1.ArktsBaseLogger.setLogCallback(t,processTsWatchEnd),watchParentPort=a,new Promise(((t,a)=>{const l=(0,rollup_1.watch)(e);r(l),l.on("event",(e=>{switch(e.code){case"BUNDLE_START":watchParentPort?.postMessage({type:build_event_1.WatchEvent.WATCH_START}),validateUnsupportedChangedFiles(e.lastChangedFiles,o),updateTriggerTsWatchWithLastChangedFiles(e.lastChangedFiles);break;case"BUNDLE_END":if(isWatchFirst&&arkts_base_log_1.ArktsBaseLogger.checkLoggerHaveErrorInfo()){const e=arkts_base_log_1.ArktsBaseLogger.getLogEvents().filter((e=>"error"===e.level)).map((e=>e.msg)).join("");a(e)}s(),updateCache(c,e.result.cache,n),isWatchFirst&&sendHotReloadWatchFileList(e.result.watchFiles),e.result.getTimings?t(e.result.getTimings()):t(),updateLastReUsedFiles(e.lastReUsedFiles),processRollupWatchEnd();break;case"ERROR":a(),arkts_base_log_1.ArktsBaseLogger.addLogEvent({time:new Date,category:"watch",level:"error",msg:e.error.message,type:constants_1.PLUGIN_LOG_TYPE}),i&&i(e.error),processRollupWatchEnd()}}))}))}function validateUnsupportedChangedFiles(e,t){for(const a of t)if(e.has(a))throw arkts_base_log_1.ArktsBaseLogger.addLogEvent({time:new Date,category:"watch",level:"error",msg:`${a} has been changed, which is not supported in watch mode. Please rebuild this module manually.`,type:constants_1.PLUGIN_LOG_TYPE}),new Error}function updateTriggerTsWatchWithLastChangedFiles(e){for(const t of e.keys())if(willTriggerTsWatch(t)){triggerTsWatch=!0;break}triggerTsWatch=void 0===triggerTsWatch||triggerTsWatch,process.env.triggerTsWatch=String(triggerTsWatch)}function readCache(e){if(e.enableFileSystemCache){const t=getCacheFile(e.cacheDirectory);if(fs_1.default.existsSync(t)){try{e.cache=(new pack_1.Packr).unpack(fs_1.default.readFileSync(t))}catch(e){logger.debug(`read cache file failed ${e.message}`)}(0,pack_1.resetPack)()}}}function updateCache(e,t,a){watchEnableFileSystemCache=e,watchCache=t,watchCacheDirectory=a}function writeCache(e,t,a){if(e&&t){const e=getCacheFile(a);try{fse.ensureDirSync(path.resolve(e,"..")),fs_1.default.writeFileSync(e,(new pack_1.Packr).pack(t))}catch(e){logger.debug(`write cache file failed ${e.message}`)}(0,pack_1.resetPack)()}}function removeCache(e){const t=getCacheFile(e);fs_1.default.rmSync(t,{force:!0})}function getCacheFile(e){return e?path.join(e,constants_1.MSGPACK_COMPILE_CACHE_FILE_NAME):constants_1.MSGPACK_COMPILE_CACHE_FILE_NAME}function willTriggerTsWatch(e){return extensionSet.has(path.extname(e))}function sendHotReloadWatchFileList(e){e&&watchParentPort?.postMessage({type:build_event_1.WatchEvent.WATCH_RESULT,content:JSON.stringify({isSuccess:!arkts_base_log_1.ArktsBaseLogger.checkLoggerHaveErrorInfo(),watchFiles:e})})}exports.writeWatchCache=writeWatchCache,exports.build=build;