import { OhosLogger } from './log.js';
import { ObfuscationOptions } from './obfuscation-options.js';
import { ProjectConfig } from './project-config.js';
export declare let entryObj: {};
export declare let widgetEntryObj: {};
export declare let cleanConfig: string[];
export declare let sdkPlugins: any[];
export declare let sdkSupportExtensions: string[];
/**
 * 加载 sdk ets-loader 编译环节的 functions
 *
 * @param {ProjectConfig} mergedProjectConfig 合并后ProjectConfig
 */
export declare function loadSdkFunctions(mergedProjectConfig: ProjectConfig): void;
/**
 * 由于会在同一个worker process中重复执行多次rollup构建,在执行完后,需要对加载sdk中内容的缓存进行清理
 */
export declare function clearSdkContext(): void;
export declare function runEtsStandaloneChecker(config: {
    config: ProjectConfig;
    entry: unknown;
}): Promise<import("@ohos/hvigor-arkts-base").LogEvent[]>;
/**
 * 调用etsloader接口, 生成har混淆文件obfuscation.txt
 *
 * @param options
 * @param loader
 * @param apiVersion
 * @param sdkVersion
 * @param isFaMode
 * @param logger
 */
export declare function generateObfuscationFile(options: ObfuscationOptions, loader: string, apiVersion: number, sdkVersion: string, isFaMode: boolean, logger: OhosLogger): Promise<void>;
