# ohos-sdkmanager-js

OpenHarmony SDK Manager的js实现
## api说明
```ts
export interface SdkInfoHandler {
  /**
   * 获取本地已安装的SDK
   *
   * @return 本地已安装sdk集合
   */
  getLocalSdks(): Map<PathAndApiVersion, Component>;
  
  /**
   * 检查本地的组件是否有每个path和版本对应的sdk，如果有sdk，就不下载，如果缺少，就去下载对应版本的组件。
   * 下载完毕后，以path->SdkComponent的形式返回，中间有任何一个组件下载失败，或者不存在，就认为是失败，直接抛异常
   * 返回一个Promise，通过Promise.then()获取SDK信息
   *
   * @return Promise<Map<PathAndApiVersion, Component>>
   */
  getOrDownload(pathAndApiVersions: PathAndApiVersion[]): Promise<Map<PathAndApiVersion, Component>>;
}
```
## 使用方法

```ts
1、获取OpenHarmony SDK
const prjSdkConfig = OhPrjSdkConfig.builder('OpenHarmony SDK根路径').nodeHome('node路径').npmConfig('.npmrc路径').sdkProxy('代理信息');
// 可以自己传入一个自定义的progress用于打印sdk内部的日志信息，这里的SimpleProgress不打印任何日志
const handler = new SimpleOhPrjSdkHandler(prjSdkConfig, new SimpleProgress());
const ohSdkInfoHandler = handler.getSdkHandler(OhPrjSdkType.OPENHARMONY);
// 获取本地所有的OpenHarmony SDK
const localSdks = ohSdkInfoHandler.getLocalSdks();
// 从本地所有的OpenHarmony SDK中查找api9的toolchains
const toolchains = localSdks.get(new PathAndApiVersion(ComponentPath.TOOLCHAINS, 9));
// 获取api9的OpenHarmony toolchains，如果本地不存在该SDK，则会触发下载
const downloadSdks = ohSdkInfoHandler.getOrDownload(new PathAndApiVersion(ComponentPath.TOOLCHAINS, 9))
const toolchains = downloadSdks.get(new PathAndApiVersion(ComponentPath.TOOLCHAINS, 9));

2、获取ArkUI-X跨平台SDK
const sdkInfoConfig = SdkInfoConfig.create('跨平台 SDK根路径').nodeHome('node路径').npmConfig('.npmrc路径').sdkProxy('代理信息');
const arkUIXSdkInfoHandler = new ArkUIXSdkInfoHandler(sdkInfoConfig, new SimpleProgress1());
// 获取本地所有的ArkUI-X跨平台SDK
const localSdks = arkuixSdkInfoHandler.getLocalSdks();
// 从本地查找api 10的ArkUI-X跨平台SDK
const sdk = localSdks.get(new PathAndApiVersion(ComponentPath.ARKUI_X, 10));
// 获取api 10的ArkUI-X跨平台SDK，如果本地不存在该SDK，则会触发下载
const downloadSdks = arkuixSdkInfoHandler.getOrDownload(new PathAndApiVersion(ComponentPath.ARKUI_X, 10))
const arkuixSdk = downloadSdks.get(new PathAndApiVersion(ComponentPath.ARKUI_X, 10));
```

## 引用方式
```json
"dependencies": {
  "@ohos/sdkmanager-common": "latest"
},
```