import { Archive, Component, Meta } from '../api/component';
export declare abstract class AbstractComponentDto implements Component {
    apiVersion: number;
    displayName: string;
    location: string | undefined;
    meta: Meta | undefined;
    path: string;
    releaseType: string;
    version: string;
    license: string;
    compareTo(other: Component): number;
    getApiVersion(): number;
    getDisplayName(): string;
    getLocation(): string | undefined;
    getMeta(): Meta | undefined;
    getPath(): string;
    getReleaseType(): string;
    getVersion(): string;
    hasApiVersion(): boolean;
    abstract getArchive(): Archive | undefined;
    getLicense(): string;
    getFullName(): string;
}
export declare class MetaDto implements Meta {
    metaVersion: string;
    getMetaVersion(): string;
}
