import { Component } from '../api/component';
import { Progress } from '../log/progress';
import { AbstractComponentDto } from './abstract-component-dto';
export declare abstract class AbstractComponentLoader {
    private readonly ETS_DISPLAY_NAME;
    private readonly JS_DISPLAY_NAME;
    /**
     * 日志
     * @protected
     */
    protected readonly progress: Progress;
    protected constructor(progress: Progress);
    /**
     * 校验Component
     * @param component
     * @protected
     */
    protected isValidComponent(component: Component): boolean;
    /**
     * 获取sdk的路径
     * @param component
     * @param sdkRoot
     * @protected
     */
    protected getLocation(component: AbstractComponentDto, sdkRoot: string): string | undefined;
    /**
     * 将path属性中的逗号替换成文件分隔符
     * @param componentPath
     * @protected
     */
    private resolveComponentPath;
    protected addToMap(sdkMap: Map<string, Component>, component: Component): void;
    protected genKey(component: Component): string;
    protected convertDisplayName(component: Component): string;
}
