"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNpmHelpUrl = void 0;
const url_contants_1 = require("../constants/url-contants");
const utils_1 = require("./utils");
const GLOBAL_SERVICE = 'com.huawei.devecostudio.global';
const DEVELOP = 'develop';
const HELP_NPM = '/en/docs/documentation/doc-guides/faq-development-environment-0000001168829643#section1311117111474';
/**
 * 获取下载js\ets的帮助链接地址
 * @param grsService
 */
function getNpmHelpUrl(grsService) {
    let domain = url_contants_1.urls.developer;
    if (grsService) {
        const grsDomain = grsService.getUrl(GLOBAL_SERVICE, DEVELOP);
        if ((0, utils_1.isNotEmpty)(grsDomain)) {
            domain = grsDomain;
        }
    }
    return `${domain}${HELP_NPM}`;
}
exports.getNpmHelpUrl = getNpmHelpUrl;
