"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidatorChains = exports.SdkValidation = exports.Status = void 0;
var Status;
(function (Status) {
    Status[Status["OK"] = 0] = "OK";
    Status[Status["INFO"] = 1] = "INFO";
    Status[Status["WARN"] = 2] = "WARN";
    Status[Status["ERROR"] = 3] = "ERROR";
})(Status = exports.Status || (exports.Status = {}));
class SdkValidation {
    constructor(status, message) {
        this.status = status;
        this.message = message;
    }
    static error(message) {
        return new SdkValidation(Status.ERROR, message);
    }
    static warn(message) {
        return new SdkValidation(Status.WARN, message);
    }
    static info(message) {
        return new SdkValidation(Status.INFO, message);
    }
}
exports.SdkValidation = SdkValidation;
SdkValidation.SUCCESS = new SdkValidation(Status.OK, '');
class ValidatorChains {
    constructor() {
        this._validatorList = new Array();
    }
    addValidator(validator) {
        this._validatorList.push(validator);
        return this;
    }
    validator(sdkPath) {
        let result = SdkValidation.SUCCESS;
        for (const filter of this._validatorList) {
            const sdkValidation = filter.validator(sdkPath);
            if (sdkValidation.status === Status.ERROR) {
                return sdkValidation;
            }
            if (sdkValidation.status !== Status.OK) {
                result = sdkValidation;
            }
        }
        return result;
    }
    static create() {
        return new ValidatorChains();
    }
}
exports.ValidatorChains = ValidatorChains;
