"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.AbstractModulePlugin=void 0;const hvigor_1=require("@ohos/hvigor"),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),common_const_js_1=require("../../const/common-const.js"),build_mode_manager_js_1=require("../../project/build-option/build-mode-manager.js"),build_option_util_js_1=require("../../project/build-option/build-option-util.js"),clean_js_1=require("../../tasks/common/clean.js"),task_names_js_1=require("../../tasks/common/task-names.js"),compile_native_hook_js_1=require("../../tasks/hook/native/compile-native-hook.js"),module_inspection_js_1=require("../../tasks/inspection/module-inspection.js"),module_task_service_factory_js_1=require("../../tasks/service/module-task-service-factory.js"),target_task_service_js_1=require("../../tasks/service/target-task-service.js"),sync_module_js_1=require("../../tasks/sync/sync-module.js"),ohos_logger_js_1=require("../../utils/log/ohos-logger.js"),ohos_plugin_id_js_1=require("./ohos-plugin-id.js");var SyncTask=task_names_js_1.TaskNames.SyncTask;const ohos_module_context_impl_js_1=require("../context/impl/ohos-module-context-impl.js"),ohosTestTargetName=common_const_js_1.DefaultTargetConst.OHOS_TEST_TARGET;class AbstractModulePlugin extends hvigor_1.HvigorSystemPlugin{constructor(e,t){super(e),this._log=ohos_logger_js_1.OhosLogger.getLogger(AbstractModulePlugin.name),this._module=t,this.moduleName=this._module.getName(),this._needExecTargetServiceList=[]}getContext(){return this.ohosModuleContext}initContext(){this.ohosModuleContext=new ohos_module_context_impl_js_1.OhosModuleContextImpl(this)}withProjectModel(e){return this._projectModel=e,this}getProjectModel(){return this._projectModel}withModuleModel(e){return this._moduleModel=e,this}getModuleModel(){return this._moduleModel}withPluginApiType(e){return this._pluginApiType=e,this}withRuntimeConfigFileName(e){return this._configFileName=e,this}initModuleTaskService(e){this.checkModuleConfigStatus(),this._moduleService=module_task_service_factory_js_1.ModuleTaskServiceFactory.initModuleTaskService(this._projectModel,this._moduleModel,e)}initBuildOptionMap(){build_option_util_js_1.BuildOptionUtil.validateBuildOptionSet(this._moduleModel),build_option_util_js_1.BuildOptionUtil.validateBinderSet(this._moduleModel),build_mode_manager_js_1.buildOptionManager.initModuleBuildOptions(this._moduleModel)}doModuleInspection(){new module_inspection_js_1.ModuleInspection(this._moduleModel).doInspection().exitOnError()}getNeedExecTargetServiceList(){return this._needExecTargetServiceList}initTargetDepends(){var e;let t,o=!1;for(const i of this._moduleService.getTargetDataSet()){const s=i[0];if(t=s.getProduct().name,i[1]){o=!0;const t=new target_task_service_js_1.TargetTaskService(s,this._moduleService);this._needExecTargetServiceList.push(t),null===(e=this._projectModel)||void 0===e||e.registryTarget(t)}}this._moduleService.getModuleModel().isHarModule()||o||this._log.warn(`Current product is '${t}'. No output will be generated because of no executable target in module: '${this._module.getName()}.'`)}initModuleCommonTasks(){this.clean=new clean_js_1.Clean(this._module,this._moduleService),this._module.registry(this.clean),this.compileNative=new compile_native_hook_js_1.CompileNativeHook(this._moduleService),this._module.registry(this.compileNative)}initModuleCommonTasksForDiffApiType(e){this.sync=new sync_module_js_1.SyncModule(this._module,SyncTask.syncTaskName(this._module.getName()),e),this._module.registry(this.sync)}initTaskDependsForAllNeedExecTarget(...e){e.forEach((e=>{this._needExecTargetServiceList.forEach((t=>{e.initTaskDepends(t)}))}))}checkModuleTarget(){this.checkHvigorCommandTarget(),this.checkTargetSourceCodeConfigFile()}checkHvigorCommandTarget(){const e=this._projectModel.getModuleSpecificTargets().get(this._moduleModel.getName());e&&e.filter((e=>"all"!==e)).forEach((e=>{this._moduleModel.getTargetOptions().filter((t=>t.name===e)).length>0||this._log._buildError(`The module target '${e}' is not found in the '${this._module.getName()}'.`)._solution("Please check the command or module target configuration.")._printErrorAndExit(),e===ohosTestTargetName&&this.checkOhosTestTarget()}))}checkTargetSourceCodeConfigFile(){this._moduleModel.getTargetOptions().forEach((e=>{const t=e.name,o=this._moduleModel.getSourceRootByTargetName(t),i=path_1.default.resolve(o,this._configFileName);if(t===ohosTestTargetName)return;if(fs_extra_1.default.existsSync(i))return;const s=`The configuration file '${i}' for the target '${t}' is not found in the '${this.moduleName}' module.`,r=`Ensure that the '${path_1.default.relative(this.moduleName,o)}' directory has been created for the module and the '${this._configFileName}' file exists in the directory.`;this._log._buildError(s)._solution(r)._printErrorAndExit()}))}checkModuleConfigStatus(){const e=this.pluginId===ohos_plugin_id_js_1.OhosPluginId.OHOS_HAP_PLUGIN,t=this._pluginApiType;void 0!==this._moduleModel&&this._moduleModel.getApiType()===t||this._log._buildError("Mismatch with apiType.")._solution(`Verify the settings in the hvigorfile or set apiType in the build-profile.json5 file to '${t}'.`)._file(this._module.getBuildFilePath())._printErrorAndExit(this._moduleModel?this._moduleModel.getName():"project"),this.checkModuleTarget(),this._moduleModel.isHapModule()!==e&&this._log._buildError("The plugin referenced in the hvigorfile does not match moduleType in the module.json5/config.json file. This may occur when the build-profile.json5 file is directly copied from a module, or when the hvigorfile has different task types registered, for example, hapTasks for a HAR module.")._solution("Make sure the module type set in build-profile.json5 is consistent with the settings of hvigorfile.")._file(this._module.getBuildFilePath())._printErrorAndExit(this._moduleModel.getName())}checkOhosTestTarget(){const e=this._moduleModel.getSourceRootByTargetName(ohosTestTargetName);if(fs_extra_1.default.existsSync(path_1.default.resolve(e,this._configFileName)))return;const t=`The './${this.moduleName}/src/main/ohosTest' directory cannot be found, or the './${this.moduleName}/src/main/ohosTest/${this._configFileName}' file.`,o=`Please open the 'build_profile.json5' file of the '${this.moduleName}' module and delete the ohosTest target. \n\t Alternatively, make sure the module directory contains the './${this.moduleName}/src/ohosTest' folder and the '${this._configFileName}' file in the folder.\n\t at ${this._moduleModel.getProfilePath()}`;this._log._buildError(t)._solution(o)._printErrorAndExit()}getTaskService(){return this._moduleService}}exports.AbstractModulePlugin=AbstractModulePlugin;