/**
 * Project级别的Plugin下下文信息
 */
export interface OhosProjectContext {
    getProjectName: () => string;
    getProjectPath: () => string;
    getBuildRootPath: () => string;
    getBuildProductOutputPath: () => string;
    getCurrentProduct: () => Product;
    getBuildMode: () => string;
}
export interface Product {
    getProductName: () => string;
    getBundleType: () => string;
    getBundleName: () => string;
}
/**
 * Module级别的Plugin上下文信息
 */
export interface OhosModuleContext {
    getModuleName: () => string;
    getModulePath: () => string;
    getModuleType: () => string;
    getBuildProductRootPath: () => string;
    targets: (callback: (target: Target) => void) => void;
}
export interface Target {
    getCurrentProduct: () => Product;
    getBuildTargetOutputPath: () => string;
    getTargetName: () => string;
}
export declare type OhosAppContext = OhosProjectContext;
export declare type OhosHapContext = OhosModuleContext;
export declare type OhosHspContext = OhosModuleContext;
export declare type OhosHarContext = OhosModuleContext;
