import { AbstractHapModulePlugin } from '../common/abstract-hap-module-plugin.js';
import { AbstractHarModulePlugin } from '../common/abstract-har-module-plugin.js';
import { HspPlugin } from '../hsp-plugin.js';
export declare class PluginInspector {
    private static _log;
    /**
     * 校验feature模块的entryModules中的字段是否合法的entry
     * @param hapPlugin
     * @public
     */
    static checkFeatureEntryModules(hapPlugin: AbstractHapModulePlugin): void;
    /**
     * 检查hap包在依赖hsp模块时是否配置了模块化编译
     * @param hapPlugin
     * @public
     */
    static checkHapEsModule(hapPlugin: AbstractHapModulePlugin): void;
    /**
     * 检查hsp包是否配置了模块化编译
     * @param hspPlugin
     * @public
     */
    static checkHspEsModule(hspPlugin: HspPlugin): void;
    /**
     * 检查原子化服务是否依赖hsp
     * @param hapPlugin
     * @public
     */
    static checkAtomicServiceHspModules(hapPlugin: AbstractHarModulePlugin): void;
}
