import { PackageJson } from 'type-fest';
import { ModuleModel } from '../../model/module/module-model.js';
import { ProjectModel } from '../../model/project/project-model.js';
import { ModuleDependencyInfo } from './module-dependency-info.js';
export declare type OhosPackageJson = PackageJson & {
    ohos?: {
        org: string;
        artifactType: string;
    };
    artifactType?: string;
};
/**
 * 管理har的依赖，提供获取当前模块依赖的数据信息
 *
 * @since 2022/5/7
 */
export declare class DependencyManager {
    private _allDependency;
    private readonly _model;
    private readonly _projectModel;
    private readonly _moduleName;
    private readonly _isFaMode;
    private readonly _isOhpmDependency;
    constructor(isFaMode: boolean, model: ModuleModel | ProjectModel, project?: ProjectModel);
    private isOhpmDependency;
    createModelDependencyInfo(): ModuleDependencyInfo;
    private collectProjectHarDependencyForHap;
    private collectHarDependency;
    private collectDependency;
    /**
     * 通过config.json/module.json5判断当前模块是否为鸿蒙依赖（har/hsp）
     *
     * @param {string} pkgPath 当前模块的路径
     * @returns {boolean}
     * @private
     */
    private getDependencyTypeByProfile;
    /**
     * 检查当前模块的moduleType是否标记为har或hsp，且model与hap是否一致
     *
     * @param {string} runtimeJson config.json/module.json5
     * @param {boolean} harIsFAMode har包是否为FA model
     * @returns {boolean}
     * @private
     */
    private checkHarOrHspStatus;
    /**
     * 1. 根据config.json/module.json5判断是不是鸿蒙依赖（har/hsp）
     * 2. 根据包管理的关键特征判断是否是har报
     * 3. 考虑循环依赖，用set过滤重复项，向queue中添加package.json路径
     *
     * @param {string} pkgJsonPath 当前模块依赖的npm的package.json/oh-package.json5路径
     * @param {OhosPackageJson} devPkgJsonObj 当前模块依赖的package.json对象
     * @returns {boolean}
     * @private
     */
    private getHarmonyDependencyType;
    /**
     * npm和ohpm的不同包管理机制下,判断一个依赖是否为har包
     * 1.ohpm只需要判断依赖中是否包含oh-package.json5
     * 2.npm需要判断package.json5中是否包含ohos字段
     *
     * @param {string} pkgPath
     * @param {OhosPackageJson} devPkgJsonPathObj
     * @returns {boolean}
     * @private
     */
    private isHarForDiffPackManagement;
    /**
     * 针对hap依赖不同har的一些业务规则校验
     * 1.FA模型不支持依赖闭源har(stage模型+esModule编译)
     *
     * @param {string} pkgPath
     * @param {OhosPackageJson} devPkgJsonPathObj
     * @private
     */
    private checkHarStatusIsCompatibleForHap;
}
