"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.StripWorker=exports.DoNativeStrip=void 0;const hvigor_1=require("@ohos/hvigor"),fs_extra_1=__importDefault(require("fs-extra")),glob_1=require("glob"),path_1=__importDefault(require("path")),base_command_builder_js_1=require("../builder/base-command-builder.js"),libs_file_cache_util_js_1=require("../utils/libs-file-cache-util.js"),ohos_logger_1=require("../utils/log/ohos-logger"),process_utils_js_1=require("../utils/process-utils.js"),so_strip_util_js_1=require("../utils/so-strip-util.js"),abstract_native_strip_js_1=require("./abstract/abstract-native-strip.js"),task_names_js_1=require("./common/task-names.js"),process_libs_js_1=require("./process-libs.js");class DoNativeStrip extends abstract_native_strip_js_1.AbstractNativeStrip{constructor(e){super(e,task_names_js_1.TaskNames.Task.DO_NATIVE_STRIP),this._log=ohos_logger_1.OhosLogger.getLogger(DoNativeStrip.name)}declareInputFiles(){const e=new hvigor_1.FileSet;return fs_extra_1.default.existsSync(this.intermediatesProcessLibs)&&e.addEntry(this.intermediatesProcessLibs,{isDirectory:!0}),e}declareOutputFiles(){return(new hvigor_1.FileSet).addEntry(this.strippedNativeLibsDir,{isDirectory:!0})}async doTaskAction(){var e,t;if(this._log.debug("Start executing task ,{}",DoNativeStrip.name),await fs_extra_1.default.ensureDir(this.strippedNativeLibsDir),so_strip_util_js_1.SoStripUtil.needStrip(this.debugSymbol)){this._log.debug("need strip,now start strip");const s={debugSymbol:this.debugSymbol,strip:null!==(e=this.strip)&&void 0!==e&&e,exclude:null!==(t=this.exclude)&&void 0!==t?t:[],intermediatesProcessLibs:this.intermediatesProcessLibs,sdkLlvmStripPath:this.sdkInfo.getSdkLlvmStrip(),outputDir:this.strippedNativeLibsDir,moduleName:this.moduleName,taskName:this.name,cacheFilePath:this.cacheFilePath,lastCache:path_1.default.resolve(this.pathInfo.getIntermediatesPatch(),"libs.json")};return this.getWorkerPool().submit(this,path_1.default.resolve(__filename,"StripWorker","doStrip"),{workInput:s}),this._log.debug("need strip,strip end"),void this._log.debug("Task execution end,{}",DoNativeStrip.name)}this._log.debug("do not need strip,now start copy so file in libs"),StripWorker.cleanStrippedSo(this.strippedNativeLibsDir,this.intermediatesProcessLibs);const s=glob_1.glob.sync("**/*.so?(.*([0-9]))",{cwd:this.intermediatesProcessLibs}).map((async e=>{const t=path_1.default.resolve(this.strippedNativeLibsDir,e),s=path_1.default.resolve(this.intermediatesProcessLibs,e);await fs_extra_1.default.copy(s,t,{overwrite:!0,recursive:!0})}));await Promise.all(s).then((()=>this._log.debug("strip task all done"))),this._log.debug("do not need strip,copied so file in libs"),this._log.debug("Task execution end,{}",DoNativeStrip.name)}initTaskDepends(){this.declareDepends(process_libs_js_1.ProcessLibs.name)}taskShouldDo(){return!0}}exports.DoNativeStrip=DoNativeStrip;const logger=ohos_logger_1.OhosLogger.getLogger("StripWorker");class StripWorker{static async doStrip(e){if(void 0===e.strip)return;StripWorker.cleanStrippedSo(e.outputDir,e.intermediatesProcessLibs),logger.debug("Stripped so file has been cleaned up");let t=[],s=[];e.strip?(t=so_strip_util_js_1.SoStripUtil.filesExcluding(e.exclude,e.intermediatesProcessLibs),s=so_strip_util_js_1.SoStripUtil.matchedFiles(e.exclude,e.intermediatesProcessLibs)):e.strip||(t=so_strip_util_js_1.SoStripUtil.matchedFiles(e.exclude,e.intermediatesProcessLibs),s=so_strip_util_js_1.SoStripUtil.filesExcluding(e.exclude,e.intermediatesProcessLibs));const i=await StripWorker.readCache(e),r=t.map((async t=>{if(await StripWorker.needStripCache(e,t,i))return StripWorker.executeStrip(t,e)})),a=s.map((async t=>StripWorker.copySoFile(t,e)));await Promise.all([...r,...a]).then((()=>{logger.debug("strip and copy task all done")}))}static async readCache(e){const t=fs_extra_1.default.existsSync(e.lastCache)?e.lastCache:e.cacheFilePath;return fs_extra_1.default.existsSync(t)?JSON.parse(await fs_extra_1.default.readFile(t,{encoding:"utf-8"})):{libs:{},stripped:{}}}static needStripCache(e,t,s){return libs_file_cache_util_js_1.LibsFileCacheUtil.isChangedSource(path_1.default.resolve(e.intermediatesProcessLibs,t),s,e.intermediatesProcessLibs,e.debugSymbol)||libs_file_cache_util_js_1.LibsFileCacheUtil.isChangedDestination(path_1.default.resolve(e.outputDir,t),s)}static cleanStrippedSo(e,t){if(!fs_extra_1.default.existsSync(e))return;function s(e){return fs_extra_1.default.readdirSync(e).reduce(((t,i)=>{const r=path_1.default.resolve(e,i);return fs_extra_1.default.statSync(r).isDirectory()?t.concat(s(r)):t.concat(r)}),[])}const i=s(e),r=new Set(s(t).map((e=>path_1.default.relative(t,e))));i.filter((t=>{const s=path_1.default.relative(e,t);return!r.has(s)})).forEach((e=>{try{fs_extra_1.default.unlinkSync(e)}catch(t){logger.error(`delete filePath: ${e} has error: ${t}`)}}))}static async copySoFile(e,t){const s=path_1.default.resolve(t.outputDir,e),i=path_1.default.resolve(t.intermediatesProcessLibs,e);fs_extra_1.default.copy(i,s,(e=>{e&&logger.error(`copy the file from ${i} to ${s} error: ${e.message}`)}))}static async executeStrip(e,t){const s=new LlvmCommandBuild(t.sdkLlvmStripPath),i=path_1.default.resolve(t.outputDir,e);fs_extra_1.default.ensureDirSync(path_1.default.dirname(i)),s.addSourceFilePath(path_1.default.resolve(t.intermediatesProcessLibs,e)),s.addOutputFilePath(i);const r=new process_utils_js_1.ProcessUtils(t.moduleName,t.taskName);await r.execute(s.build())}}exports.StripWorker=StripWorker;class LlvmCommandBuild extends base_command_builder_js_1.BaseCommandBuilder{constructor(e){super([]),this.commandList.push(e)}addOutputFilePath(e){this.commandList.push(`-o${e}`)}addSourceFilePath(e){this.commandList.push(`${e}`)}}