import { FileSet, TaskInputValue } from '@ohos/hvigor';
import { TargetTaskService } from './service/target-task-service.js';
import { AbstractGenerateLoaderJson } from './abstract-generate-loader-json.js';
/**
 * 生成loader需要的json文件
 *
 * @since 2022/3/3
 */
export declare class GenerateLoaderJson extends AbstractGenerateLoaderJson {
    private readonly aceLoaderJson;
    private readonly nodeModulesPath;
    private readonly harNameOhmMap;
    private readonly moduleSrcMainPath;
    private readonly moduleSrcMockPath;
    private readonly insightIntentJsonPath;
    private readonly mockConfigJsonPath;
    private readonly compileEntry;
    private readonly dynamicImportLibInfo;
    private readonly moduleJson5Path;
    private readonly modulePath;
    private insightIntentJson;
    protected isPreview: boolean | undefined;
    private readonly apPath?;
    private readonly tempApPath;
    private readonly tempApDir;
    private readonly anBuildOutPutPath;
    private readonly fallbackAnBuild;
    private readonly typeExts;
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    initTaskDepends(): void;
    constructor(taskService: TargetTaskService);
    protected getWorkerConfig(): string[] | undefined;
    protected doTaskAction(): void;
    private collectMockFileEntry;
    private logBuildError;
    /**
     * 校验规则ability在module.json5下的extensionAbilities数组中存在对应名称的name，
     * 其次对应name的type必须为form，该form ability对应的卡片配置文件下存在一个对应name的form
     *
     * @param intent
     * @param extensionMap
     * @param cause
     * @param detail
     * @private
     */
    private extensionAbilitiesValidate;
    /**
     * uiAbility/ability字段的校验
     * serviceExtension/ability字段校验，
     * 校验规则ability在module.json5下的extensionAbilities数组中存在对应名称的name，
     * 其次对应name的type必须为service
     *
     * @param intent
     * @param abilitiesSet
     * @param extensionMap
     * @param cause
     * @param detail
     * @private
     */
    private serviceExtensionValidate;
    /**
     * ability字段在module.json中的abilities或extensionAbilities中是否存在
     *
     * @param intent
     * @param abilitiesSet
     * @param extensionMap
     * @param cause
     * @param detail
     * @private
     */
    private uiExtensionValidate;
    /**
     * insight_intent.json文件的业务校验
     *
     * @private
     */
    private validateForInsightIntentJson;
    /**
     *  读取InsightIntent.json中的srcEntry
     */
    private readInsightIntentSrcEntry;
    /**
     * 检查当前Sdk版本是否支持Aot，只检查ohos场景
     * @private
     */
    private checkAotCompatibleSdkVersion;
    private handleAotFields;
    private warnAnBuildMode;
    /**
     * 生成harNameOhmMap对象
     * @private
     */
    private getHarNameOhmMap;
    /**
     * 共享hsp包配置loader.json的harNameOhmMap时，获取package.json的main字段，如main字段为空则试图获取types字段
     * @param dependency
     */
    private getHspDependencyPackageMainName;
    /**
     * 共享hsp包配置loader.json的harNameOhmMap时，获取module.json5的name字段
     * @param dependency
     */
    private getHspDependencyModuleName;
    /**
     * 使用策略模式，
     *
     * @param {AotConfigsParams} params
     * @returns {Record<string, string>}
     * @private
     */
    private getAotStrategy;
    /**
     * 当ap路径存在时返回的loader.json片段
     * @param {AotConfigsParams} conf
     * @private
     */
    private withApPath;
    /**
     * 当ap路径不存在时返回的loader.json片段
     * @param {AotConfigsParams} conf
     * @private
     */
    private withoutApPath;
    /**
     * 当不使能aot编译时，返回空片段
     * @returns {{}}
     * @private
     */
    private withEmpty;
    /**
     * api9上配置了apPath但没有配置aotCompileMode，需要报错
     * @private
     */
    private mismatchAotCompileMode;
    /**
     * api9上配置了partial模式时没有配置apPath，需要报错
     * @private
     */
    private partialEmptyPath;
    /**
     * 配置了partial模式时apPath路径不存在，需要报错
     * @private
     */
    private invalidPath;
    /**
     * 路径非以.ap后缀结尾，需要报错
     * @private
     */
    private invalidSuffix;
    /**
     * 处理dynamic import
     * @private
     */
    private processDynamicImport;
    /**
     * 处理本地、远程har依赖形式dynamicImport
     * @param dynamicImport
     * @param dynamicImportLibInfo
     * @private
     */
    private processHarDynamicImport;
    /**
     * 处理npm/hsp/.so形式dynamic import
     * @param dynamicImport
     * @param dynamicImportLibInfo
     * @private
     */
    private processOtherDynamicImport;
    /**
     * 处理间接依赖
     * @private
     */
    private processIndirectDependency;
    /**
     * 收集package/path数组中的所有dynamicImport
     * @param runtimeOnlyObj
     * @private
     */
    private collectDynamicImport;
    /**
     * 处理间接依赖的dynamicImport相关信息 npm包不作处理
     * @param dependency
     * @param dynamicImportList
     * @private
     */
    private processIndirectDependencyInfo;
    /**
     * 处理.so类型的间接依赖的dynamicImportLibInfo
     * @param dependency
     * @param dynamicImport
     * @private
     */
    private processIndirectSoDependencyInfo;
    /**
     * 写入compileEntry/compileEntryDir和dynamicImportLibInfo
     * @param dependencyList
     * @param dynamicImport
     * @private
     */
    private writeIndirectDependencyInfo;
    /**
     * 获取依赖入口文件
     * @param realDependencyPath
     * @param dynamicImportOhPkgObj
     * @private
     */
    private getEntryMainFilePath;
    /**
     * 获取har dependency的模块 模块名
     * @param dependency
     * @private
     */
    private getHostModuleName;
    /**
     * 获取har依赖的dependencyInfo中的moduleName
     * @param dependency
     * @param dynamicImport
     * @private
     */
    private getHarDependencyModuleName;
    /**
     * 通过oh-package.json5获取moduleName
     * @param dependencyRootPath
     * @private
     */
    private getModuleNameFromOhPkgJson;
    /**
     * 通过入口文件路径地址判断当前依赖是否为本地依赖
     * 若包含oh_modules字段则为远程依赖
     * @param path 依赖入口文件路径地址
     * @private
     */
    private isLocalDependency;
    /**
     * 检查dynamicImportLibsInfo中是否已存在依赖信息
     * 处理存在同名但非同版本依赖重复写入dynamicImportLibsInfo的场景
     * 收集依赖遵循距离优先原则 若已写入对象中则跳过后续版本的写入 即模块级优先于工程级依赖调用
     * @param dependencyName
     * @private
     */
    private existInDynamicImportLibsInfo;
    /**
     * 判断dynamic import是否为har dependency
     * @param dynamicImport
     * @private
     */
    private isHarDependency;
    /**
     * 判断dynamic import是否为hsp dependency
     * @param dynamicImport
     * @private
     */
    private isHspDependency;
}
/**
 * 写入dynamicImportLibInfo的dynamicImport对象
 */
export interface DynamicImportObj {
    hostModulesInfo: HostModulesInfoObj[];
    moduleName: string;
    entryFilePath: string;
    isLocalDependency: boolean;
    pkgPath: string;
}
/**
 * 三方包信息对象
 */
export interface HostModulesInfoObj {
    hostDependencyName: string;
    hostModuleName: string;
}
