import { Project } from '@ohos/hvigor';
import { FileSet } from '@ohos/hvigor';
import { TaskInputValue } from '@ohos/hvigor';
import { BasePackAppTask } from './base/base-pack-app-task.js';
import { ProjectTaskService } from './service/project-task-service.js';
/**
 * 调用打包工具生成.app
 *
 * @since 2022/1/10
 */
export declare class PackageApp extends BasePackAppTask {
    private readonly outPath;
    private readonly allDestDir;
    private readonly allSrcHapPath;
    private readonly allDestHapPath;
    private readonly allSrcHspPath;
    private allDestHspPathList;
    private readonly allRemoteHspPathMap;
    private readonly remoteHspModuleSet;
    private readonly projectBuildProfilePath;
    private readonly curProduct;
    private readonly defaultPackageLimitSize;
    declareExecutionCommand(): string;
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    constructor(project: Project, taskService: ProjectTaskService);
    initTaskDepends(): void;
    protected doTaskAction(): Promise<void>;
    /**
     * 获得打包app的命令
     * @returns {string[]} 打包app的命令
     */
    private getPackAppCommand;
    /**
     * 遍历product的所有hap包,
     * 将需要打到app的hap去除-unsigned, 然后生成到同级的app目录下, 最后输出路径到字符串数组中
     */
    private getUnpackedHaps;
    private initWithHapModuleData;
    private initWithHspModuleData;
    private initRemoteHsp;
    /**
     * 检查打app包时传入包包名是否重复
     * @param paths
     * @private
     */
    private checkOutputName;
}
