/**
 * Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
 *
 */
import { ArkCompileProjectModelType } from '@ohos/hvigor-arkts-compose';
import { ProjectModel } from '../../model/project/project-model.js';
/**
 * 全局的工程信息，只需要计算一次，模块级别任务可直接获取，不需要重复计算
 */
export declare class GlobalProjectDataService {
    private static INSTANCE;
    private compileProjectModel;
    private projectPkgJsonFileHash;
    private allModuleNameHash;
    private projectRemoteHspPromise;
    private moduleRemoteHspSet;
    static getInstance(): GlobalProjectDataService;
    initGlobalProjectData(projectModel: ProjectModel): void;
    getCompileProjectModel(): ArkCompileProjectModelType;
    getProjectPkgJsonFileHash(): string;
    getAllModuleNameHash(): string;
    setProjectRemoteHspPromise(promise: Promise<void>): void;
    getProjectRemoteHspPromise(): Promise<void> | undefined;
    setModuleRemoteHspPromise(moduleName: string): void;
    getModuleRemoteHspPromise(): Set<string>;
    private initCompileProjectModel;
    private initProjectPkgJsonFileHash;
    private initAllModuleNameHash;
}
