import { TaskDetails } from '@ohos/hvigor';
import { AotCompileModeEnum } from '../../enum/aot-compile-mode-enum.js';
import { ModuleTargetRes } from '../../model/res/res-model.js';
import { BuildOpt, NativeLib } from '../../options/build/build-opt.js';
import { SdkInfo } from '../../sdk/sdk-info.js';
import { ModuleTargetData } from '../data/hap-task-target-data.js';
import { ModuleTaskService } from './module-task-service.js';
/**
 * 以Target为维度创建不同的task，提供target相关的数据信息和管理
 *
 * @since 2022/8/11
 */
export declare class TargetTaskService {
    private readonly targetData;
    private readonly buildOption;
    private readonly _sdkInfo;
    private moduleService;
    constructor(targetData: ModuleTargetData, moduleService: ModuleTaskService);
    trace(): void;
    setup(): Promise<void>;
    buildTaskName(taskDetails: TaskDetails, targetName?: string): TaskDetails;
    getTargetData(): ModuleTargetData;
    getBuildOption(): BuildOpt;
    getNativeLibOption(): NativeLib;
    /**
     * 提供当前target绝对路径化的workerConfig
     * @returns {string[]}
     */
    getWorkerConfig(): string[];
    /**
     * 获取模块级build-profile.json5中所有自定义buildProfileFields的变量
     */
    getBuildProfileFields(): object | undefined;
    /**
     * 获取模块target资源目录集合
     */
    getResourceDirs(): string[];
    /**
     *  相对路径转换为资源绝对路径并校验
     *
     * @param {string}  resourcesDirs 资源路径
     */
    private convertResourceAbsolutePath;
    getAnBuildMode(): AotCompileModeEnum;
    getApPath(): string | undefined;
    getApAbsolutePath(): string;
    getCustomTypes(): string[] | undefined;
    isDebug(): boolean;
    /**
     * 判断是否为开源/闭源
     * 1.混淆配置仅release生效
     * 2.debug模式下均为开源
     * 3.release模式下检查arkOptions?.obfuscation?.ruleOptions?.enable字段
     *    3.1.若enable配置为false或缺省,则不开启混淆为开源
     *    3.2.若enable配置为true,则开启混淆为闭源
     */
    isOpenSource(): boolean;
    /**
     * 判断构建模式是debug还是release
     */
    getBuildMode(): "Release" | "Debug";
    needPackBin(target: ModuleTargetData): boolean;
    getSdkInfo(): SdkInfo;
    getModuleService(): ModuleTaskService;
    static getFormJsonArr(targetRes: ModuleTargetRes): string[];
    private static formJsonFileCheck;
    getModuleRequiredSDKs(): string[];
}
/**
 * 拼接不同target的任务名
 *
 * @param {string} targetName
 * @param {string} taskName
 * @return {string}
 */
export declare function computeTargetTaskName(targetName: string, taskName: string): string;
