import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosSaasPlayer } from './nativeclass/OhosSaasPlayer';
import { LiveSts } from './source/LiveSts';
import { VidAuth } from './source/VidAuth';
import { VidMps } from './source/VidMps';
import { VidSts } from './source/VidSts';
import { StsInfo } from './source/StsInfo';
class VidAuthSourceRefreshCallback {
    constructor(o13) {
        this.apsaraVideoPlayer = o13;
    }
    onSuccess(n13) {
        this.apsaraVideoPlayer.refreshVidAuth(n13);
    }
    onError(m13) {
        this.apsaraVideoPlayer.refreshVidAuthWithError(m13);
    }
}
class URLSourceRefreshCallback {
    constructor(l13) {
        this.apsaraVideoPlayer = l13;
    }
    onSuccess(k13) {
        this.apsaraVideoPlayer.refreshUrlSource(k13);
    }
    onError(j13) {
        this.apsaraVideoPlayer.refreshUrlSourceWithError(j13);
    }
}
class URLSourceExpiredListener {
    constructor(i13) {
        this.apsaraVideoPlayer = i13;
    }
    onUrlSourceExpired(f13, g13) {
        const h13 = new URLSourceRefreshCallback(this.apsaraVideoPlayer);
        this.apsaraVideoPlayer.handleUrlSourceExpired(f13, h13);
    }
}
class VidAuthExpiredListener {
    constructor(e13) {
        this.apsaraVideoPlayer = e13;
    }
    onVidAuthExpired(c13, d13) {
        this.apsaraVideoPlayer.onVidAuthExpired(c13, d13);
    }
}
class InnerHasListenerCallbackSaas {
    constructor(b13) {
        this.apsaraVideoPlayer = b13;
    }
    hasListener(a13) {
        if (this.apsaraVideoPlayer == null) {
            return false;
        }
        switch (a13) {
            case 0:
                return this.apsaraVideoPlayer.mOutOnURLSourceExpiredListener != null;
            case 1:
                return this.apsaraVideoPlayer.mOutOnVidAuthExpiredListener != null;
            default:
                return false;
        }
    }
}
export class ApsaraVideoPlayer extends UrlVideoPlayer {
    constructor(y12, z12) {
        super(y12, z12);
        this.mOutOnVidAuthExpiredListener = null;
    }
    setVidAuthDataSource(w12) {
        let x12 = this.getCorePlayer();
        if (x12 instanceof OhosSaasPlayer) {
            if (w12 instanceof VidAuth) {
                x12.setVidAuthSource(w12);
            }
        }
    }
    setVidStsDataSource(u12) {
        let v12 = this.getCorePlayer();
        if (v12 instanceof OhosSaasPlayer) {
            if (u12 instanceof VidSts) {
                v12.setVidStsSource(u12);
            }
        }
    }
    setVidMpsDataSource(s12) {
        let t12 = this.getCorePlayer();
        if (t12 instanceof OhosSaasPlayer) {
            if (s12 instanceof VidMps) {
                t12.setVidMpsSource(s12);
            }
        }
    }
    setLiveStsDataSource(q12) {
        let r12 = this.getCorePlayer();
        if (r12 instanceof OhosSaasPlayer) {
            if (q12 instanceof LiveSts) {
                r12.setLiveStsDataSource(q12);
            }
        }
    }
    updateVidAuth(o12) {
        let p12 = this.getCorePlayer();
        if (p12 instanceof OhosSaasPlayer) {
            if (o12 instanceof VidAuth) {
                p12.updateVidAuth(o12);
            }
        }
    }
    updateStsInfo(m12) {
        let n12 = this.getCorePlayer();
        if (n12 instanceof OhosSaasPlayer) {
            if (m12 instanceof StsInfo) {
                n12.updateStsInfo(m12);
            }
        }
    }
    createAlivcMediaPlayer(k12) {
        let l12 = new OhosSaasPlayer(k12);
        l12.setOnVidAuthExpiredListener(new VidAuthExpiredListener(this));
        l12.setOnURLSourceExpiredListener(new URLSourceExpiredListener(this));
        l12.setHasListenerCallbackSaas(new InnerHasListenerCallbackSaas(this));
        return l12;
    }
    setOnVidAuthExpiredListener(j12) {
        this.mOutOnVidAuthExpiredListener = j12;
    }
    onVidAuthExpired(g12, h12) {
        if (this.mOutOnVidAuthExpiredListener) {
            const i12 = new VidAuthSourceRefreshCallback(this);
            this.mOutOnVidAuthExpiredListener.onVidAuthExpired(g12, i12);
        }
    }
    handleUrlSourceExpired(e12, f12) {
        if (this.mOutOnURLSourceExpiredListener) {
            this.mOutOnURLSourceExpiredListener.onUrlSourceExpired(e12, f12);
        }
    }
    refreshVidAuth(c12) {
        let d12 = this.getCorePlayer();
        if (d12 instanceof OhosSaasPlayer) {
            d12.refreshVidAuth(c12);
        }
    }
    refreshVidAuthWithError(a12) {
        let b12 = this.getCorePlayer();
        if (b12 instanceof OhosSaasPlayer) {
            b12.refreshVidAuthWithError(a12);
        }
    }
}
