import { Log } from '../utils/Log';
const log = new Log('AVPBase');
const preparedListenerMap = new WeakMap();
const onInfoListenerMap = new WeakMap();
const onRenderingStartListenerMap = new WeakMap();
const onStateChangedListenerMap = new WeakMap();
const onCompletionListenerMap = new WeakMap();
const onLoadingStatusListenerMap = new WeakMap();
const onErrorListenerMap = new WeakMap();
const onVideoSizeChangedListenerMap = new WeakMap();
const onSeekCompleteListenerMap = new WeakMap();
const onSubtitleDisplayListenerMap = new WeakMap();
const onVideoRenderedListenerMap = new WeakMap();
const onAudioInterruptEventListenerMap = new WeakMap();
const onTrackReadyListenerMap = new WeakMap();
const onSubTrackReadyListenerMap = new WeakMap();
const onSwichStreamListenerMap = new WeakMap();
const onAVNotSyncStatusListenerMap = new WeakMap();
const onTrackChangedListenerMap = new WeakMap();
const onSnapShotListenerMap = new WeakMap();
const onSeiDataListenerMap = new WeakMap();
const onNetworkStatusMap = new WeakMap();
const onUrlExpiredListenerMap = new WeakMap();
export class AVPBase {
    constructor(g20, h20) {
        this.mOutMediaInfo = null;
        this.mOutSubMediaInfo = null;
        this.mOutOnPreparedListener = null;
        this.mInnerOnPreparedListener = new InnerPrepareListener(this);
        this.mOutOnInfoListener = null;
        this.mInnerOnInfoListener = new InnerInfoListener(this);
        this.mOutOnRenderingStartListener = null;
        this.mInnerOnRenderingStartListener = new InnerRenderingStartListener(this);
        this.mOutOnStateChangedListener = null;
        this.mInnerOnStateChangedListener = new InnerStateChangedListener(this);
        this.mOutOnVideoSizeChangedListener = null;
        this.mInnerOnVideoSizeChangedListener = new InnerVideoSizeChangedListener(this);
        this.mOutOnLoadingStatusListener = null;
        this.mInnerOnLoadingStatusListener = new InnerLoadingStatusListener(this);
        this.mOutOnSeekCompleteListener = null;
        this.mInnerOnSeekCompleteListener = new InnerSeekCompleteListener(this);
        this.mOutOnCompletionListener = null;
        this.mInnerOnCompletionListener = new InnerCompletionListener(this);
        this.mOutOnVideoRenderedListener = null;
        this.mInnerOnVideoRenderedListener = new InnerVideoRenderedListener(this);
        this.mOutOnSubtitleDisplayListener = null;
        this.mInnerOnSubtitleDisplayListener = new InnerSubtitleDisplayListener(this);
        this.mOutOnErrorListener = null;
        this.mInnerOnErrorListener = new InnerErrorListener(this);
        this.mOutOnAudioInterruptEventListener = null;
        this.mInnerOnAudioInterruptEventListener = new InnerAudioInterruptEventListener(this);
        this.mOutOnTrackReadyListener = null;
        this.mInnerOnTrackReadyListener = new InnerTrackReadyListener(this);
        this.mOutOnSubTrackReadyListener = null;
        this.mInnerOnSubTrackReadyListener = new InnerSubTrackReadyListener(this);
        this.mOutOnStreamSwitchedListener = null;
        this.mInnerOnStreamSwitchedListener = new InnerStreamSwitchedListener(this);
        this.mOutOnAVNotSyncStatusListener = null;
        this.mInnerOnAVNotSyncStatusListener = new InnerOnAVNotSyncStatusListener(this);
        this.mOutOnNetworkStatsListener = null;
        this.mInnerOnNetworkStatsListener = new InnerOnNetworkStatsListener(this);
        this.mOutOnTrackChangedListener = null;
        this.mInnerOnTrackChangedListener = new InnerTrackChangedListener(this);
        this.mOutOnSnapShotListener = null;
        this.mInnerOnSnapShotListener = new InnerSnapShotListener(this);
        this.mOutOnSeiDataListener = null;
        this.mInnerOnSeiDataListener = new InnerSeiDataListener(this);
        this.mOutOnUrlExpiredListener = null;
        this.mInnerOnUrlExpiredListener = new InnerUrlExpiredListener(this);
        this.mInnerHasListenerCallback = new InnerHasListenerCallback(this);
        this.mContext = g20;
        this.mTraceId = h20;
        this.mCorePlayer = this.createAlivcMediaPlayer(g20);
        this.mCorePlayer.setTraceId(this.mTraceId);
        preparedListenerMap.set(this, this.mInnerOnPreparedListener);
        onInfoListenerMap.set(this, this.mInnerOnInfoListener);
        onRenderingStartListenerMap.set(this, this.mInnerOnRenderingStartListener);
        onStateChangedListenerMap.set(this, this.mInnerOnStateChangedListener);
        onCompletionListenerMap.set(this, this.mInnerOnCompletionListener);
        onLoadingStatusListenerMap.set(this, this.mInnerOnLoadingStatusListener);
        onErrorListenerMap.set(this, this.mInnerOnErrorListener);
        onVideoSizeChangedListenerMap.set(this, this.mInnerOnVideoSizeChangedListener);
        onSeekCompleteListenerMap.set(this, this.mInnerOnSeekCompleteListener);
        onSubtitleDisplayListenerMap.set(this, this.mInnerOnSubtitleDisplayListener);
        onVideoRenderedListenerMap.set(this, this.mInnerOnVideoRenderedListener);
        onAudioInterruptEventListenerMap.set(this, this.mInnerOnAudioInterruptEventListener);
        onTrackReadyListenerMap.set(this, this.mInnerOnTrackReadyListener);
        onSubTrackReadyListenerMap.set(this, this.mInnerOnSubTrackReadyListener);
        onSwichStreamListenerMap.set(this, this.mInnerOnStreamSwitchedListener);
        onAVNotSyncStatusListenerMap.set(this, this.mInnerOnAVNotSyncStatusListener);
        onNetworkStatusMap.set(this, this.mInnerOnNetworkStatsListener);
        onTrackChangedListenerMap.set(this, this.mInnerOnTrackChangedListener);
        onSnapShotListenerMap.set(this, this.mInnerOnSnapShotListener);
        onSeiDataListenerMap.set(this, this.mInnerOnSeiDataListener);
        onUrlExpiredListenerMap.set(this, this.mInnerOnUrlExpiredListener);
        this.bindListener();
    }
    getNativeContextAddr() {
        return this.mCorePlayer?.getNativeContextAddr();
    }
    prepare() {
        this.prepareInner();
    }
    prepareInner() {
        this.mCorePlayer?.prepare();
    }
    getCorePlayer() {
        return this.mCorePlayer;
    }
    start() {
        this.startInner();
    }
    startInner() {
        this.mCorePlayer?.start();
    }
    pause() {
        this.pauseInner();
    }
    pauseInner() {
        this.mCorePlayer?.pause();
    }
    stop() {
        let f20 = "protected.playEvent.user.stop";
        this.setGlobalTime(f20);
        this.stopInner();
    }
    stopInner() {
        this.mCorePlayer?.stop();
    }
    setAutoPlay(e20) {
        this.mCorePlayer?.setAutoPlay(e20);
    }
    setSurfaceId(d20) {
        this.mCorePlayer?.setSurfaceId(d20);
    }
    setSpeed(c20) {
        this.mCorePlayer?.setSpeed(c20);
    }
    setVolume(b20) {
        this.mCorePlayer?.setVolume(b20);
    }
    getVolume() {
        return this.mCorePlayer?.getVolume();
    }
    seekTo(z19, a20) {
        this.mCorePlayer?.seekTo(z19, a20);
    }
    setStartTime(x19, y19) {
        this.mCorePlayer?.setStartTime(x19, y19);
    }
    getDuration() {
        return this.mCorePlayer?.getDuration();
    }
    getPlayedDuration() {
        return this.mCorePlayer?.getPlayedDuration();
    }
    getCurrentPosition() {
        return this.mCorePlayer?.getCurrentPosition();
    }
    getBufferedPosition() {
        return this.mCorePlayer?.getBufferedPosition();
    }
    getPlayerStatus() {
        return this.mCorePlayer?.getPlayerStatus();
    }
    enableHardwareDecoder(w19) {
        this.mCorePlayer?.enableHardwareDecoder(w19);
    }
    release() {
        let v19 = "protected.playEvent.user.destroy";
        this.setGlobalTime(v19);
        this.releaseInner();
    }
    setGlobalTime(u19) {
        this.mCorePlayer?.setGlobalTime(u19);
    }
    releaseInner() {
        this.mCorePlayer?.release();
    }
    releaseAsync() {
        let s19 = "protected.playEvent.user.destroy";
        this.setGlobalTime(s19);
        log.info('releaseAsync');
        this.pause();
        setTimeout(() => {
            this.stopInner();
            this.releaseInner();
        }, 0);
    }
    setMute(r19) {
        this.mCorePlayer?.setMute(r19);
    }
    isMuted() {
        return this.mCorePlayer?.isMuted();
    }
    setScaleMode(q19) {
        this.mCorePlayer?.setScaleMode(q19);
    }
    getScaleMode() {
        return this.mCorePlayer?.getScaleMode();
    }
    setLoop(p19) {
        this.mCorePlayer?.setLoop(p19);
    }
    isLoop() {
        return this.mCorePlayer?.isLoop();
    }
    getVideoWidth() {
        return this.mCorePlayer?.getVideoWidth();
    }
    getVideoHeight() {
        return this.mCorePlayer?.getVideoHeight();
    }
    getVideoRotation() {
        return this.mCorePlayer?.getVideoRotation();
    }
    reload() {
        this.mCorePlayer?.reload();
    }
    setRotateMode(o19) {
        this.mCorePlayer?.setRotateMode(o19);
    }
    getRotateMode() {
        return this.mCorePlayer?.getRotateMode();
    }
    setMirrorMode(n19) {
        this.mCorePlayer?.setMirrorMode(n19);
    }
    getMirrorMode() {
        return this.mCorePlayer?.getMirrorMode();
    }
    setAlphaRenderMode(m19) {
        this.mCorePlayer?.setAlphaRenderMode(m19);
    }
    getAlphaRenderMode() {
        return this.mCorePlayer?.getAlphaRenderMode();
    }
    setVideoBackgroundColor(l19) {
        this.mCorePlayer?.setVideoBackgroundColor(l19);
    }
    getSpeed() {
        return this.mCorePlayer?.getSpeed();
    }
    isAutoPlay() {
        return this.mCorePlayer?.isAutoPlay();
    }
    setConfig(k19) {
        this.mCorePlayer?.setConfig(k19);
    }
    getConfig() {
        return this.mCorePlayer?.getConfig();
    }
    setPlayerScene(j19) {
        this.mCorePlayer?.setPlayerScene(j19);
    }
    setOption(g19, h19) {
        let i19 = "player_option_" + g19 + "_str";
        this.mCorePlayer?.setOption(i19, h19);
    }
    setOptionNum(d19, e19) {
        let f19 = "player_option_" + d19.toString() + "_str";
        this.mCorePlayer?.setOption(f19, e19.toString());
    }
    getOption(c19) {
        return this.mCorePlayer?.getOption(c19);
    }
    selectTrack(b19) {
        this.mCorePlayer?.selectTrack(b19);
    }
    switchStream(a19) {
        this.mCorePlayer?.switchStream(a19);
    }
    getMediaInfo() {
        return this.mOutMediaInfo;
    }
    getSubMediaInfo() {
        return this.mOutSubMediaInfo;
    }
    currentTrack(z18) {
        if (this.mCorePlayer) {
            return this.mCorePlayer.getCurrentTrack(z18);
        }
        else {
            return null;
        }
    }
    addExtSubtitle(y18) {
        this.mCorePlayer?.addExtSubtitle(y18);
    }
    ;
    selectExtSubtitle(w18, x18) {
        this.mCorePlayer?.selectExtSubtitle(w18, x18);
    }
    setStreamDelay(u18, v18) {
        this.mCorePlayer?.setStreamDelay(u18, v18);
    }
    setMaxAccurateSeekDelta(t18) {
        this.mCorePlayer?.setMaxAccurateSeekDelta(t18);
    }
    setCacheConfig(s18) {
        this.mCorePlayer?.setCacheConfig(s18);
    }
    setIPResolveType(r18) {
        this.mCorePlayer?.setIPResolveType(r18);
    }
    setFastStart(q18) {
        this.mCorePlayer?.setFastStart(q18);
    }
    snapShot() {
        this.mCorePlayer?.snapShot();
    }
    clearScreen() {
        this.mCorePlayer?.clearScreen();
    }
    getCacheFilePathByUrl(p18) {
        return this.mCorePlayer?.getCacheFilePathByUrl(p18) ?? '';
    }
    getCacheFilePathByVid(l18, m18, n18, o18) {
        return this.mCorePlayer?.getCacheFilePathByVid(l18, m18, n18, o18) ?? '';
    }
    getPropertyString(k18) {
        return this.mCorePlayer?.getPropertyString(k18) ?? '';
    }
    setDefaultBandWidth(j18) {
        this.mCorePlayer?.setDefaultBandWidth(j18);
    }
    setDefaultResolution(i18) {
        this.mCorePlayer?.setDefaultResolution(i18);
    }
    setAutoBandWidth(h18) {
        this.mCorePlayer?.setAutoBandWidth(h18);
    }
    isAutoBandWidth() {
        return this.mCorePlayer?.isAutoBandWidth() ?? false;
    }
    sendCustomEvent(g18) {
        this.mCorePlayer?.sendCustomEvent(g18);
    }
    setVideoTag(f18) {
        this.mCorePlayer?.setVideoTag(f18);
    }
    setUserData(e18) {
        this.mCorePlayer?.setUserData(e18);
    }
    setTraceId(d18) {
        this.mCorePlayer?.setTraceId(d18);
    }
    getUserData() {
        return this.mCorePlayer?.getUserData() ?? '';
    }
    refreshPlayerUrl(c18) {
        this.mCorePlayer?.refreshPlayerUrl(c18);
    }
    refreshPlayerUrlWithError(b18) {
        this.mCorePlayer?.refreshPlayerUrlWithError(b18);
    }
    bindListener() {
        this.mCorePlayer?.setOnPreparedListener(this.mInnerOnPreparedListener);
        this.mCorePlayer?.setOnInfoListener(this.mInnerOnInfoListener);
        this.mCorePlayer?.setOnRenderingStartListener(this.mInnerOnRenderingStartListener);
        this.mCorePlayer?.setOnStateChangedListener(this.mInnerOnStateChangedListener);
        this.mCorePlayer?.setOnVideoSizeChangedListener(this.mInnerOnVideoSizeChangedListener);
        this.mCorePlayer?.setOnLoadingStatusListener(this.mInnerOnLoadingStatusListener);
        this.mCorePlayer?.setOnSeekCompleteListener(this.mInnerOnSeekCompleteListener);
        this.mCorePlayer?.setOnCompletionListener(this.mInnerOnCompletionListener);
        this.mCorePlayer?.setOnVideoRenderedListener(this.mInnerOnVideoRenderedListener);
        this.mCorePlayer?.setOnSubtitleDisplayListener(this.mInnerOnSubtitleDisplayListener);
        this.mCorePlayer?.setOnErrorListener(this.mInnerOnErrorListener);
        this.mCorePlayer?.setOnAudioInterruptEventListener(this.mInnerOnAudioInterruptEventListener);
        this.mCorePlayer?.setOnTrackReadyListener(this.mInnerOnTrackReadyListener);
        this.mCorePlayer?.setOnSubTrackReadyListener(this.mInnerOnSubTrackReadyListener);
        this.mCorePlayer?.setOnStreamSwitchedListener(this.mInnerOnStreamSwitchedListener);
        this.mCorePlayer?.setOnAVNotSyncStatusListener(this.mInnerOnAVNotSyncStatusListener);
        this.mCorePlayer?.setOnNetworkStatsListener(this.mInnerOnNetworkStatsListener);
        this.mCorePlayer?.setOnTrackChangedListener(this.mInnerOnTrackChangedListener);
        this.mCorePlayer?.setOnSnapShotListener(this.mInnerOnSnapShotListener);
        this.mCorePlayer?.setOnSeiDataListener(this.mInnerOnSeiDataListener);
        this.mCorePlayer?.setOnUrlExpiredListener(this.mInnerOnUrlExpiredListener);
        this.mCorePlayer?.setHasListenerCallback(this.mInnerHasListenerCallback);
    }
    setOnPreparedListener(a18) {
        this.mOutOnPreparedListener = a18;
    }
    setOnInfoListener(z17) {
        this.mOutOnInfoListener = z17;
    }
    setOnRenderingStartListener(y17) {
        this.mOutOnRenderingStartListener = y17;
    }
    setOnStateChangedListener(x17) {
        this.mOutOnStateChangedListener = x17;
    }
    setOnCompletionListener(w17) {
        this.mOutOnCompletionListener = w17;
    }
    setOnAVNotSyncStatusListener(v17) {
        this.mOutOnAVNotSyncStatusListener = v17;
    }
    setOnNetworkStatsListener(u17) {
        this.mOutOnNetworkStatsListener = u17;
    }
    setOnStreamSwitchedListener(t17) {
        this.mOutOnStreamSwitchedListener = t17;
    }
    setOnLoadingStatusListener(s17) {
        this.mOutOnLoadingStatusListener = s17;
    }
    setOnErrorListener(r17) {
        this.mOutOnErrorListener = r17;
    }
    setOnVideoSizeChangedListener(q17) {
        this.mOutOnVideoSizeChangedListener = q17;
    }
    setOnSeekCompleteListener(p17) {
        this.mOutOnSeekCompleteListener = p17;
    }
    setOnSubtitleDisplayListener(o17) {
        this.mOutOnSubtitleDisplayListener = o17;
    }
    setOnVideoRenderedListener(n17) {
        this.mOutOnVideoRenderedListener = n17;
    }
    setOnAudioInterruptEventListener(m17) {
        this.mOutOnAudioInterruptEventListener = m17;
    }
    setOnTrackReadyListener(l17) {
        this.mOutOnTrackReadyListener = l17;
    }
    setOnSubTrackReadyListener(k17) {
        this.mOutOnSubTrackReadyListener = k17;
    }
    setOnTrackChangedListener(j17) {
        this.mOutOnTrackChangedListener = j17;
    }
    setOnSnapShotListener(i17) {
        this.mOutOnSnapShotListener = i17;
    }
    setOnSeiDataListener(h17) {
        this.mOutOnSeiDataListener = h17;
    }
    setOnUrlExpiredListener(g17) {
        this.mOutOnUrlExpiredListener = g17;
    }
    onPrepared() {
        if (this.mOutOnPreparedListener != null) {
            this.mOutOnPreparedListener.onPrepared();
        }
    }
    onInfo(f17) {
        if (this.mOutOnInfoListener != null) {
            this.mOutOnInfoListener.onInfo(f17);
        }
    }
    onRenderingStart() {
        if (this.mOutOnRenderingStartListener != null) {
            this.mOutOnRenderingStartListener.onRenderingStart();
        }
    }
    onStateChanged(e17) {
        if (this.mOutOnStateChangedListener != null) {
            this.mOutOnStateChangedListener.onStateChanged(e17);
        }
    }
    onVideoSizeChanged(c17, d17) {
        if (this.mOutOnVideoSizeChangedListener != null) {
            this.mOutOnVideoSizeChangedListener.onVideoSizeChanged(c17, d17);
        }
    }
    onLoadingBegin() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(a17, b17) {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingProgress(a17, b17);
        }
    }
    onLoadingEnd() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingEnd();
        }
    }
    onSeekEnd() {
        if (this.mOutOnSeekCompleteListener != null) {
            this.mOutOnSeekCompleteListener.onSeekComplete();
        }
    }
    onCompletion() {
        if (this.mOutOnCompletionListener != null) {
            this.mOutOnCompletionListener.onCompletion();
        }
    }
    onVideoRendered(y16, z16) {
        if (this.mOutOnVideoRenderedListener != null) {
            this.mOutOnVideoRenderedListener.onVideoRendered(y16, z16);
        }
    }
    onSubtitleShow(v16, w16, x16) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleShow(v16, w16, x16);
        }
    }
    onSubtitleExtAdded(t16, u16) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleExtAdded(t16, u16);
        }
    }
    onSubtitleHide(r16, s16) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHide(r16, s16);
        }
    }
    onSubtitleHeader(p16, q16) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHeader(p16, q16);
        }
    }
    onError(o16) {
        if (this.mOutOnErrorListener != null) {
            this.mOutOnErrorListener.onError(o16);
        }
    }
    onAudioInterruptEvent(n16) {
        if (this.mOutOnAudioInterruptEventListener != null) {
            this.mOutOnAudioInterruptEventListener.onAudioInterruptEvent(n16);
        }
    }
    onTrackReady(m16) {
        this.mOutMediaInfo = m16;
        if (this.mOutOnTrackReadyListener != null) {
            this.mOutOnTrackReadyListener.onTrackReady(m16);
        }
    }
    onSubTrackReady(l16) {
        this.mOutSubMediaInfo = l16;
        if (this.mOutOnSubTrackReadyListener != null) {
            this.mOutOnSubTrackReadyListener.onSubTrackReady(l16);
        }
    }
    onSwitchedSuccess(k16) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedSuccess(k16);
        }
    }
    onSwitchedFail(i16, j16) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedFail(i16, j16);
        }
    }
    onAVNotSyncStart(h16) {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncStart(h16);
        }
    }
    onAVNotSyncEnd() {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncEnd();
        }
    }
    onNetworkStats(g16) {
        if (this.mOutOnNetworkStatsListener != null) {
            this.mOutOnNetworkStatsListener.onNetworkStats(g16);
        }
    }
    onChangedSuccess(f16) {
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedSuccess(f16);
        }
    }
    onSnapShot(c16, d16, e16) {
        if (this.mOutOnSnapShotListener != null) {
            this.mOutOnSnapShotListener.onSnapShot(c16, d16, e16);
        }
    }
    onSeiData(a16, b16) {
        if (this.mOutOnSeiDataListener != null) {
            this.mOutOnSeiDataListener.onSeiData(a16, b16);
        }
    }
    onUrlExpired(x15, y15) {
        if (this.mOutOnUrlExpiredListener != null) {
            const z15 = new UrlRefreshCallbackImpl(this);
            this.mOutOnUrlExpiredListener.onUrlExpired(x15, z15);
        }
    }
}
class InnerPrepareListener {
    constructor(w15) {
        this.avbBaseWR = w15;
    }
    onPrepared() {
        if (this.avbBaseWR != null) {
            this.avbBaseWR.onPrepared();
        }
    }
}
class InnerInfoListener {
    constructor(v15) {
        this.avpBaseRef = v15;
    }
    onInfo(u15) {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onInfo(u15);
        }
    }
}
class InnerRenderingStartListener {
    constructor(t15) {
        this.avpBaseRef = t15;
    }
    onRenderingStart() {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onRenderingStart();
        }
    }
}
class InnerStateChangedListener {
    constructor(s15) {
        this.avpBaseRef = s15;
    }
    onStateChanged(r15) {
        this.avpBaseRef.onStateChanged(r15);
    }
}
class InnerVideoSizeChangedListener {
    constructor(q15) {
        this.avpBaseRef = q15;
    }
    onVideoSizeChanged(o15, p15) {
        this.avpBaseRef.onVideoSizeChanged(o15, p15);
    }
}
class InnerLoadingStatusListener {
    constructor(n15) {
        this.avpBaseRef = n15;
    }
    onLoadingBegin() {
        this.avpBaseRef.onLoadingBegin();
    }
    onLoadingProgress(l15, m15) {
        this.avpBaseRef.onLoadingProgress(l15, m15);
    }
    onLoadingEnd() {
        this.avpBaseRef.onLoadingEnd();
    }
}
class InnerSeekCompleteListener {
    constructor(k15) {
        this.avpBaseRef = k15;
    }
    onSeekComplete() {
        this.avpBaseRef.onSeekEnd();
    }
}
class InnerCompletionListener {
    constructor(j15) {
        this.avpBaseRef = j15;
    }
    onCompletion() {
        this.avpBaseRef.onCompletion();
    }
}
class InnerVideoRenderedListener {
    constructor(i15) {
        this.avpBaseRef = i15;
    }
    onVideoRendered(g15, h15) {
        this.avpBaseRef.onVideoRendered(g15, h15);
    }
}
class InnerSubtitleDisplayListener {
    constructor(f15) {
        this.avpBaseRef = f15;
    }
    onSubtitleShow(c15, d15, e15) {
        this.avpBaseRef.onSubtitleShow(c15, d15, e15);
    }
    onSubtitleExtAdded(a15, b15) {
        this.avpBaseRef.onSubtitleExtAdded(a15, b15);
    }
    onSubtitleHide(y14, z14) {
        this.avpBaseRef.onSubtitleHide(y14, z14);
    }
    onSubtitleHeader(w14, x14) {
        this.avpBaseRef.onSubtitleHeader(w14, x14);
    }
}
class InnerErrorListener {
    constructor(v14) {
        this.avpBaseRef = v14;
    }
    onError(u14) {
        this.avpBaseRef.onError(u14);
    }
}
class InnerAudioInterruptEventListener {
    constructor(t14) {
        this.avpBaseRef = t14;
    }
    onAudioInterruptEvent(s14) {
        this.avpBaseRef.onAudioInterruptEvent(s14);
    }
}
class InnerTrackReadyListener {
    constructor(r14) {
        this.avpBaseRef = r14;
    }
    onTrackReady(q14) {
        this.avpBaseRef.onTrackReady(q14);
    }
}
class InnerSubTrackReadyListener {
    constructor(p14) {
        this.avpBaseRef = p14;
    }
    onSubTrackReady(o14) {
        this.avpBaseRef.onSubTrackReady(o14);
    }
}
class InnerStreamSwitchedListener {
    constructor(n14) {
        this.avpBaseRef = n14;
    }
    onSwitchedSuccess(m14) {
        this.avpBaseRef.onSwitchedSuccess(m14);
    }
    onSwitchedFail(k14, l14) {
        this.avpBaseRef.onSwitchedFail(k14, l14);
    }
}
class InnerOnAVNotSyncStatusListener {
    constructor(j14) {
        this.avpBaseRef = j14;
    }
    onAVNotSyncStart(i14) {
        this.avpBaseRef.onAVNotSyncStart(i14);
    }
    onAVNotSyncEnd() {
        this.avpBaseRef.onAVNotSyncEnd();
    }
}
class InnerOnNetworkStatsListener {
    constructor(h14) {
        this.avpBaseRef = h14;
    }
    onNetworkStats(g14) {
        this.avpBaseRef.onNetworkStats(g14);
    }
}
class InnerTrackChangedListener {
    constructor(f14) {
        this.avpBaseRef = f14;
    }
    onChangedSuccess(e14) {
        this.avpBaseRef.onChangedSuccess(e14);
    }
}
class InnerSnapShotListener {
    constructor(d14) {
        this.avpBaseRef = d14;
    }
    onSnapShot(a14, b14, c14) {
        this.avpBaseRef.onSnapShot(a14, b14, c14);
    }
}
class InnerSeiDataListener {
    constructor(z13) {
        this.avpBaseRef = z13;
    }
    onSeiData(x13, y13) {
        this.avpBaseRef.onSeiData(x13, y13);
    }
}
class InnerUrlExpiredListener {
    constructor(w13) {
        this.avpBaseRef = w13;
    }
    onUrlExpired(u13, v13) {
        this.avpBaseRef.onUrlExpired(u13, v13);
    }
}
class InnerHasListenerCallback {
    constructor(t13) {
        this.avpBase = t13;
    }
    hasListener(s13) {
        if (this.avpBase == null) {
            return false;
        }
        switch (s13) {
            case 0:
                return this.avpBase.mOutOnUrlExpiredListener != null;
            default:
                return false;
        }
    }
}
class UrlRefreshCallbackImpl {
    constructor(r13) {
        this.avpBase = r13;
    }
    onSuccess(q13) {
        this.avpBase.refreshPlayerUrl(q13.url);
    }
    onError(p13) {
        this.avpBase.refreshPlayerUrlWithError(p13);
    }
}
