import { ALLOW_PRE_RENDER } from './IPlayer';
export class AVPLBase {
    constructor(m23, n23) {
        this.mNativePlayer = this.getNativePlayerWithContext(m23, n23);
        this.mPreRenderPlayer = this.getPrerenderPlayerWithContext(m23, n23);
        this.mListPlayer = this.createListPlayer(m23, n23, this.mNativePlayer.getNativeContextAddr(), this.mPreRenderPlayer.getNativeContextAddr());
    }
    getCurrentPlayer() {
        let l23 = this.getCurrentPlayerIndex();
        if (l23 == 1) {
            return this.mPreRenderPlayer;
        }
        else {
            return this.mNativePlayer;
        }
    }
    getCurrentPrerenderPlayer(k23) {
        if (k23 == 0) {
            return this.mNativePlayer;
        }
        else if (k23 == 1) {
            return this.mPreRenderPlayer;
        }
        return undefined;
    }
    getCorePlayer() {
        return this.mListPlayer;
    }
    getNativePlayer() {
        return this.mNativePlayer;
    }
    getPrerenderPlayer() {
        return this.mPreRenderPlayer;
    }
    removeSource(j23) {
        this.mListPlayer?.removeSource(j23);
    }
    clear() {
        this.mListPlayer?.clear();
    }
    getCurrentUid() {
        return this.mListPlayer?.getCurrentUid();
    }
    setMaxPreloadMemorySizeMB(i23) {
        this.mListPlayer?.setMaxPreloadMemorySizeMB(i23);
    }
    getMaxPreloadMemorySizeMB() {
        return this.mListPlayer?.getMaxPreloadMemorySizeMB();
    }
    SetMultiBitratesMode(h23) {
        this.mListPlayer?.SetMultiBitratesMode(h23);
    }
    GetMultiBitratesMode() {
        return this.mListPlayer?.GetMultiBitratesMode();
    }
    setPreloadCount(g23) {
        this.mListPlayer?.setPreloadCount(g23);
    }
    setPreloadScene(f23) {
        this.mListPlayer?.setPreloadScene(f23);
    }
    enablePreloadStrategy(d23, e23) {
        this.mListPlayer?.enablePreloadStrategy(d23, e23);
    }
    setPreloadStrategy(b23, c23) {
        this.mListPlayer?.setPreloadStrategyParam(b23, c23);
    }
    setPreloadCountWithPrevAndNext(z22, a23) {
        this.mListPlayer?.setPreloadCountWithPrevAndNext(z22, a23);
    }
    getNativeContextAddr() {
        return this.getCurrentPlayer()?.getNativeContextAddr();
    }
    prepare() {
        this.getCurrentPlayer().prepare();
    }
    start() {
        this.getCurrentPlayer()?.start();
    }
    pause() {
        this.getCurrentPlayer().pause();
    }
    stop() {
        this.getCurrentPlayer().stop();
    }
    setAutoPlay(y22) {
        this.getCurrentPlayer().setAutoPlay(y22);
    }
    setSurfaceId(x22) {
        this.getCurrentPlayer().setSurfaceId(x22);
    }
    setSpeed(w22) {
        this.getCurrentPlayer().setSpeed(w22);
    }
    setVolume(v22) {
        this.getCurrentPlayer().setVolume(v22);
    }
    getVolume() {
        return this.getCurrentPlayer().getVolume();
    }
    seekTo(t22, u22) {
        this.getCurrentPlayer().seekTo(t22, u22);
    }
    setStartTime(r22, s22) {
        this.getCurrentPlayer().setStartTime(r22, s22);
    }
    getDuration() {
        return this.getCurrentPlayer().getDuration();
    }
    getPlayedDuration() {
        return this.getCurrentPlayer().getPlayedDuration();
    }
    getCurrentPosition() {
        return this.getCurrentPlayer().getCurrentPosition();
    }
    getBufferedPosition() {
        return this.getCurrentPlayer().getBufferedPosition();
    }
    getPlayerStatus() {
        return this.getCurrentPlayer().getPlayerStatus();
    }
    enableHardwareDecoder(q22) {
        this.getCurrentPlayer().enableHardwareDecoder(q22);
    }
    release() {
        this.mListPlayer?.release();
        this.mNativePlayer?.release();
        this.mPreRenderPlayer?.release();
    }
    releaseAsync() {
        this.release();
    }
    setMute(p22) {
        this.getCurrentPlayer().setMute(p22);
    }
    isMuted() {
        return this.getCurrentPlayer().isMuted();
    }
    setScaleMode(o22) {
        this.getCurrentPlayer().setScaleMode(o22);
    }
    getScaleMode() {
        return this.getCurrentPlayer().getScaleMode();
    }
    setLoop(n22) {
        this.getCurrentPlayer().setLoop(n22);
    }
    isLoop() {
        return this.getCurrentPlayer().isLoop();
    }
    getVideoWidth() {
        return this.getCurrentPlayer().getVideoWidth();
    }
    getVideoHeight() {
        return this.getCurrentPlayer().getVideoHeight();
    }
    getVideoRotation() {
        return this.getCurrentPlayer().getVideoRotation();
    }
    reload() {
        this.getCurrentPlayer().reload();
    }
    setRotateMode(m22) {
        this.getCurrentPlayer().setRotateMode(m22);
    }
    getRotateMode() {
        return this.getCurrentPlayer().getRotateMode();
    }
    setMirrorMode(l22) {
        this.getCurrentPlayer().setMirrorMode(l22);
    }
    getMirrorMode() {
        return this.getCurrentPlayer().getMirrorMode();
    }
    setAlphaRenderMode(k22) {
        this.getCurrentPlayer().setAlphaRenderMode(k22);
    }
    getAlphaRenderMode() {
        return this.getCurrentPlayer().getAlphaRenderMode();
    }
    setVideoBackgroundColor(j22) {
        this.getCurrentPlayer().setVideoBackgroundColor(j22);
    }
    getSpeed() {
        return this.getCurrentPlayer().getSpeed();
    }
    isAutoPlay() {
        return this.getCurrentPlayer().isAutoPlay();
    }
    setConfig(i22) {
        if (this.mNativePlayer != null) {
            this.mNativePlayer.setConfig(i22);
        }
        if (this.mPreRenderPlayer != null) {
            this.mPreRenderPlayer.setConfig(i22);
        }
    }
    getConfig() {
        return this.getCurrentPlayer().getConfig();
    }
    setPlayerScene(h22) {
        this.getCurrentPlayer().setPlayerScene(h22);
    }
    setOption(f22, g22) {
        this.getCurrentPlayer().setOption(f22, g22);
    }
    setOptionNum(d22, e22) {
        this.getCurrentPlayer().setOptionNum(d22, e22);
        if (d22 == ALLOW_PRE_RENDER) {
            if (this.getCurrentPlayer() == this.mPreRenderPlayer) {
                this.mNativePlayer?.setOptionNum(d22, e22);
            }
            else {
                this.mPreRenderPlayer?.setOptionNum(d22, e22);
            }
        }
    }
    getOption(c22) {
        return this.getCurrentPlayer().getOption(c22);
    }
    selectTrack(b22) {
        this.getCurrentPlayer()?.selectTrack(b22);
    }
    switchStream(a22) {
        this.getCurrentPlayer()?.switchStream(a22);
    }
    getMediaInfo() {
        return this.getCurrentPlayer()?.getMediaInfo();
    }
    getSubMediaInfo() {
        return this.getCurrentPlayer()?.getSubMediaInfo();
    }
    currentTrack(z21) {
        return this.getCurrentPlayer()?.currentTrack(z21);
    }
    addExtSubtitle(y21) {
        this.getCurrentPlayer()?.addExtSubtitle(y21);
    }
    selectExtSubtitle(w21, x21) {
        this.getCurrentPlayer()?.selectExtSubtitle(w21, x21);
    }
    setStreamDelay(u21, v21) {
        this.getCurrentPlayer()?.setStreamDelay(u21, v21);
    }
    setMaxAccurateSeekDelta(t21) {
        this.getCurrentPlayer()?.setMaxAccurateSeekDelta(t21);
    }
    setCacheConfig(s21) {
        this.getCurrentPlayer()?.setCacheConfig(s21);
    }
    setIPResolveType(r21) {
        this.getCurrentPlayer()?.setIPResolveType(r21);
    }
    setFastStart(q21) {
        this.getCurrentPlayer()?.setFastStart(q21);
    }
    snapShot() {
        this.getCurrentPlayer()?.snapShot();
    }
    clearScreen() {
        this.getCurrentPlayer()?.clearScreen();
    }
    getCacheFilePathByUrl(p21) {
        return this.getCurrentPlayer()?.getCacheFilePathByUrl(p21) || '';
    }
    getCacheFilePathByVid(l21, m21, n21, o21) {
        return this.getCurrentPlayer()?.getCacheFilePathByVid(l21, m21, n21, o21) || '';
    }
    getPropertyString(k21) {
        return this.getCurrentPlayer()?.getPropertyString(k21) || '';
    }
    setDefaultBandWidth(j21) {
        this.getCurrentPlayer()?.setDefaultBandWidth(j21);
    }
    setDefaultResolution(i21) {
        this.getCurrentPlayer()?.setDefaultResolution(i21);
    }
    setAutoBandWidth(h21) {
        this.getCurrentPlayer()?.setAutoBandWidth(h21);
    }
    isAutoBandWidth() {
        return this.getCurrentPlayer()?.isAutoBandWidth() ?? false;
    }
    sendCustomEvent(g21) {
        this.getCurrentPlayer()?.sendCustomEvent(g21);
    }
    setVideoTag(f21) {
        this.getCurrentPlayer()?.setVideoTag(f21);
    }
    setUserData(e21) {
        this.getCurrentPlayer()?.setUserData(e21);
    }
    setTraceId(d21) {
        this.getCurrentPlayer()?.setTraceId(d21);
    }
    getUserData() {
        return this.getCurrentPlayer()?.getUserData() || '';
    }
    setOnPreparedListener(c21) {
        this.getCurrentPlayer().setOnPreparedListener(c21);
    }
    setOnInfoListener(b21) {
        this.getCurrentPlayer().setOnInfoListener(b21);
    }
    setOnRenderingStartListener(a21) {
        this.getCurrentPlayer().setOnRenderingStartListener(a21);
    }
    setOnStateChangedListener(z20) {
        this.getCurrentPlayer().setOnStateChangedListener(z20);
    }
    setOnCompletionListener(y20) {
        this.getCurrentPlayer().setOnCompletionListener(y20);
    }
    setOnLoadingStatusListener(x20) {
        this.getCurrentPlayer().setOnLoadingStatusListener(x20);
    }
    setOnAVNotSyncStatusListener(w20) {
        this.getCurrentPlayer()?.setOnAVNotSyncStatusListener(w20);
    }
    setOnNetworkStatsListener(v20) {
        this.getCurrentPlayer()?.setOnNetworkStatsListener(v20);
    }
    setOnErrorListener(u20) {
        this.getCurrentPlayer().setOnErrorListener(u20);
    }
    setOnVideoSizeChangedListener(t20) {
        this.getCurrentPlayer().setOnVideoSizeChangedListener(t20);
    }
    setOnSeekCompleteListener(s20) {
        this.getCurrentPlayer().setOnSeekCompleteListener(s20);
    }
    setOnSubtitleDisplayListener(r20) {
        this.getCurrentPlayer().setOnSubtitleDisplayListener(r20);
    }
    setOnVideoRenderedListener(q20) {
        this.getCurrentPlayer().setOnVideoRenderedListener(q20);
    }
    setOnAudioInterruptEventListener(p20) {
        this.getCurrentPlayer().setOnAudioInterruptEventListener(p20);
    }
    setOnSubTrackReadyListener(o20) {
        this.getCurrentPlayer()?.setOnSubTrackReadyListener(o20);
    }
    setOnTrackReadyListener(n20) {
        this.getCurrentPlayer()?.setOnTrackReadyListener(n20);
    }
    setOnTrackChangedListener(m20) {
        this.getCurrentPlayer()?.setOnTrackChangedListener(m20);
    }
    setOnSnapShotListener(l20) {
        this.getCurrentPlayer()?.setOnSnapShotListener(l20);
    }
    setOnSeiDataListener(k20) {
        this.getCurrentPlayer()?.setOnSeiDataListener(k20);
    }
    setOnStreamSwitchedListener(j20) {
        this.getCurrentPlayer()?.setOnStreamSwitchedListener(j20);
    }
    setOnUrlExpiredListener(i20) {
        this.getCurrentPlayer()?.setOnUrlExpiredListener(i20);
    }
}
