import { UrlVideoListPlayer } from './UrlVideoListPlayer';
import { Log } from '../utils/Log';
import { ApsaraVideoPlayer } from './ApsaraVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
import { LiveSts } from './source/LiveSts';
import { VidSts } from './source/VidSts';
import { VidAuth } from './source/VidAuth';
import { VidMps } from './source/VidMps';
import { StsInfo } from './source/StsInfo';
import { OhosSaasListPlayer } from './nativeclass/OhosSaasListPlayer';
export class ApsaraVideoListPlayer extends UrlVideoListPlayer {
    constructor(y11, z11) {
        super(y11, z11);
        this.mmLog = new Log("NativePlayerBase_ApsaraVideListPlayer");
        this.mSaasVidePlayer = null;
        this.mSaaSPrerenderPlayer = null;
    }
    setOnVidAuthExpiredListener(w11) {
        let x11 = super.getCorePlayer();
        if (x11 instanceof ApsaraVideoPlayer) {
            x11.setOnVidAuthExpiredListener(w11);
        }
    }
    createListPlayer(s11, t11, u11, v11) {
        return new OhosSaasListPlayer(s11, u11, v11, true);
    }
    getNativePlayerWithContext(q11, r11) {
        if (this.mSaasVidePlayer == null) {
            this.mSaasVidePlayer = new ApsaraVideoPlayer(q11, r11);
        }
        return this.mSaasVidePlayer;
    }
    getPrerenderPlayerWithContext(o11, p11) {
        if (this.mSaaSPrerenderPlayer == null) {
            this.mSaaSPrerenderPlayer = new ApsaraVideoPlayer(o11, p11);
        }
        return this.mSaaSPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let n11 = super.getCorePlayer();
        if (n11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getCurrentPlayerIndex");
            return n11.getCurrentPlayerIndex();
        }
        return 0;
    }
    stop() {
        super.stop();
        let m11 = super.getCorePlayer();
        if (m11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("stop");
            m11.stop();
        }
    }
    getPreRenderPlayer() {
        let k11 = super.getCorePlayer();
        if (k11 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getPreRenderPlayer");
            let l11 = k11.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(l11);
        }
        return undefined;
    }
    setVidAuthDataSource(i11) {
        let j11 = super.getCorePlayer();
        if (j11 instanceof ApsaraVideoPlayer) {
            if (i11 instanceof VidAuth) {
                j11.setVidAuthDataSource(i11);
            }
        }
    }
    setVidStsDataSource(g11) {
        let h11 = super.getCorePlayer();
        if (h11 instanceof ApsaraVideoPlayer) {
            if (g11 instanceof VidSts) {
                h11.setVidStsDataSource(g11);
            }
        }
    }
    setVidMpsDataSource(e11) {
        let f11 = super.getCorePlayer();
        if (f11 instanceof ApsaraVideoPlayer) {
            if (e11 instanceof VidMps) {
                f11.setVidMpsDataSource(e11);
            }
        }
    }
    setLiveStsDataSource(c11) {
        let d11 = super.getCorePlayer();
        if (d11 instanceof ApsaraVideoPlayer) {
            if (c11 instanceof LiveSts) {
                d11.setLiveStsDataSource(c11);
            }
        }
    }
    updateVidAuth(a11) {
        let b11 = super.getCorePlayer();
        if (b11 instanceof ApsaraVideoPlayer) {
            if (a11 instanceof VidAuth) {
                b11.updateVidAuth(a11);
            }
        }
    }
    updateStsInfo(y10) {
        let z10 = super.getCorePlayer();
        if (z10 instanceof ApsaraVideoPlayer) {
            if (y10 instanceof StsInfo) {
                z10.updateStsInfo(y10);
            }
        }
    }
}
