import { AVPBase } from './AVPBase';
import { OhosUrlPlayer } from './nativeclass/OhosUrlPlayer';
import { UrlSource } from './source/UrlSource';
class URLSourceRefreshCallback {
    constructor(t47) {
        this.urlVideoPlayer = t47;
    }
    onSuccess(s47) {
        this.urlVideoPlayer.refreshUrlSource(s47);
    }
    onError(r47) {
        this.urlVideoPlayer.refreshUrlSourceWithError(r47);
    }
}
class URLSourceExpiredListener {
    constructor(q47) {
        this.urlVideoPlayer = q47;
    }
    onUrlSourceExpired(n47, o47) {
        const p47 = new URLSourceRefreshCallback(this.urlVideoPlayer);
        this.urlVideoPlayer.onUrlSourceExpired(n47, p47);
    }
}
export class UrlVideoPlayer extends AVPBase {
    constructor(l47, m47) {
        super(l47, m47);
        this.mOutOnURLSourceExpiredListener = null;
    }
    createAlivcMediaPlayer(j47) {
        let k47 = new OhosUrlPlayer(j47);
        k47.setOnURLSourceExpiredListener(new URLSourceExpiredListener(this));
        return k47;
    }
    setUrlDataSource(h47) {
        let i47 = this.getCorePlayer();
        if (i47 instanceof OhosUrlPlayer) {
            if (h47 instanceof UrlSource) {
                i47.setUrlDataSource(h47);
            }
        }
    }
    setOnURLSourceExpiredListener(g47) {
        this.mOutOnURLSourceExpiredListener = g47;
    }
    onUrlSourceExpired(d47, e47) {
        if (this.mOutOnURLSourceExpiredListener) {
            const f47 = new URLSourceRefreshCallback(this);
            this.mOutOnURLSourceExpiredListener.onUrlSourceExpired(d47, f47);
        }
    }
    refreshUrlSource(b47) {
        let c47 = this.getCorePlayer();
        if (c47 instanceof OhosUrlPlayer) {
            c47.refreshUrlSource(b47);
        }
    }
    refreshUrlSourceWithError(z46) {
        let a47 = this.getCorePlayer();
        if (a47 instanceof OhosUrlPlayer) {
            a47.refreshUrlSourceWithError(z46);
        }
    }
}
