export class BaseRequest {
    constructor(m49) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = m49;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(j49, k49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(j49, k49);
        }
    }
    sendFailResult(g49, h49, i49) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(g49, h49, i49);
        }
    }
    dealMsg(f49) {
        if (f49.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(f49.data, f49.extra);
        }
        else if (f49.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(f49.failCode, f49.data, f49.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
