import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(j50) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = j50;
    }
    setRefer(i50) {
        this.mReferer = i50;
    }
    setTimeout(h50) {
        this.mNetworkTimeout = h50;
    }
    setHttpProxy(g50) {
        this.mHttpProxy = g50;
    }
    setUserAgent(f50) {
        this.mUserAgent = f50;
    }
    setCustomHeaders(e50) {
        this.mCustomHeaders = e50;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let q49 = [];
        if (this.mReferer != null) {
            q49.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            q49.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let c50 of this.mCustomHeaders) {
                if (c50 != null) {
                    q49.push(c50);
                }
            }
        }
        let r49 = "";
        let s49 = false;
        if (this.mHttpProxy != null) {
            r49 = this.mHttpProxy;
            s49 = true;
        }
        else {
            r49 = this.mUrl;
        }
        let t49 = {
            method: http.RequestMethod.GET,
            header: q49,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: s49,
        };
        return new Promise((v49, w49) => {
            if (this.urlRequest == null) {
                v49(null);
                return;
            }
            this.urlRequest.request(r49, t49, (y49, z49) => {
                if (y49) {
                    console.error('error:' + JSON.stringify(y49));
                    this.urlRequest?.destroy();
                    v49(null);
                    return;
                }
                if (z49.responseCode == http.ResponseCode.OK) {
                    if (z49.resultType == http.HttpDataType.STRING) {
                        v49(z49.result);
                    }
                    else if (z49.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let a50 = util.TextDecoder.create('utf-8');
                        let b50 = a50.decodeToString(new Uint8Array(z49.result));
                        v49(b50 ? b50 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + z49.resultType);
                        this.urlRequest?.destroy();
                        v49(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + z49.responseCode);
                    this.urlRequest?.destroy();
                    v49(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
