import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (g51, h51) => {
            let i51 = Logger.getLevel(g51);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(i51, h51);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(e51) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (e51 != null) {
                Logger.sAppContext = e51;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(d51) {
        this.mLogCallback = d51;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(c51) {
        this.mCurrentLogLevel = c51;
        premierlibrary.nLoggerSetLevel(c51);
    }
    setLogOption(a51, b51) {
        switch (a51) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", b51);
                break;
        }
    }
    getLogLevel() {
        let z50 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(z50);
    }
    enableConsoleLog(y50) {
        this.mEnableConsoleLog = y50;
        premierlibrary.nLoggerEnableConsole(y50);
    }
    callback(w50, x50) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(w50, x50);
        }
    }
    static getLevel(v50) {
        switch (v50) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (u50) {
    u50[u50["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    u50[u50["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    u50[u50["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    u50[u50["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    u50[u50["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    u50[u50["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    u50[u50["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (t50) {
    t50[t50["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
