"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseCompare_1 = require("./common/baseCompare");
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var findIndex_1 = __importDefault(require("./findIndex"));
/**
 *遍历 collection（集合）元素，返回 predicate（断言函数）第一个返回真值的第一个元素。
 * predicate（断言函数）调用3个参数： (value, index|key, collection)。
 * @param collection (Array|Object): 一个用来迭代的集合。
 * @param predicate  (Array|Function|Object|string): 每次迭代调用的函数。
 * @param fromIndex 开始搜索的索引位置。
 * @returns (*): 返回匹配元素，否则返回 undefined。
 */
function find(collection, predicate, fromIndex) {
    var target = Object(collection);
    var isArrayFlag = (0, isArrayLike_1.default)(target);
    var resultIndex = -1;
    if (!isArrayFlag) {
        var findIteratee_1 = (0, baseCompare_1.wrapIteratee)(predicate);
        var keys = Object.keys(target);
        resultIndex = (0, findIndex_1.default)(keys, function (key) {
            return findIteratee_1(target[key], key, target);
        }, fromIndex);
        if (resultIndex > -1) {
            return target[keys[resultIndex]];
        }
    }
    else {
        resultIndex = (0, findIndex_1.default)(collection, predicate, fromIndex);
        if (resultIndex > -1) {
            return target[resultIndex];
        }
    }
    return undefined;
}
exports.default = find;
