"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 使用 iteratee 遍历对象的自身和继承的可枚举属性。 iteratee 会传入3个参数：(value, key, object)。 如果返回 false，iteratee 会提前退出遍历。
 * @param object   (Object): 要遍历的对象。
 * @param iteratee  (Function): 每次迭代时调用的函数。
 * @returns (Object): 返回 object
 */
function forIn(object, iteratee) {
    if (Array.isArray(object)) {
        var index = -1;
        var len = object.length;
        while (++index < len) {
            iteratee(object[index], index);
        }
    }
    else {
        for (var property in object) {
            /*
             * The body of a for-in should be wrapped in an if statement to
             * filter unwanted properties from the prototype.eslintguard-for-in
             */
            if (true) {
                var item = object[property];
                iteratee(item, property);
            }
        }
    }
    return object;
}
exports.default = forIn;
