"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var get_1 = __importDefault(require("./get"));
var isMatch_1 = __importStar(require("./isMatch"));
var stringToPaths_1 = require("./common/stringToPaths");
var cloneDeep_1 = __importDefault(require("./cloneDeep"));
var utils_1 = require("./common/utils");
/**
 * 返回一个函数，该函数接受一个入参obj。
 * 该函数执行时，先获得rawPath在obj中的值，再调用isMatch比较此值是否与rawSrcValue相匹配，最终返回是否匹配
 * @param rawPath，用于在obj中取得指定路径的值和rawSrcValue进行匹配
 * @param rawSrcValue，用于匹配的参考对象
 */
function matchesProperty(rawPath, rawSrcValue) {
    // srcValue是真正用于和obj中值进行匹配的变量，这么做可以防止rawSrcValue上的修改影响了最终匹配结果
    var srcValue = (0, cloneDeep_1.default)(rawSrcValue);
    var isMatchSource = function (obj) {
        var path = (0, stringToPaths_1.getObjValidPathFromGeneralPath)(obj, rawPath);
        var slicedPath = path.slice(0, path.length - 1);
        // 先获得路径中倒数第二层指向的值
        var objValue = slicedPath.length ? (0, get_1.default)(obj, slicedPath) : obj;
        var lastAttribute = path[path.length - 1] || '';
        // 如果还未取到路径最终指向的值就已经无法匹配了，直接返回false
        if (objValue === undefined || objValue === null) {
            return false;
        }
        if ((0, utils_1.tagName)(objValue) === '[object Object]' && !(lastAttribute in objValue)) {
            return false;
        }
        // 此时赋值为路径最终指向的值
        objValue = objValue[lastAttribute];
        var typeOfSrcValue = typeof srcValue;
        if ((0, isMatch_1.needDeeperCompare)(objValue, srcValue) || typeOfSrcValue === 'function') {
            return (0, isMatch_1.default)(objValue, srcValue);
        }
        // 二者都是简单的值（boolean, string等），直接使用===判断是否匹配
        return objValue === srcValue;
    };
    return isMatchSource;
}
exports.default = matchesProperty;
