"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var isInteger_1 = __importDefault(require("./isInteger"));
var isNaN_1 = __importDefault(require("./isNaN"));
/**
 * 获取`array`数组的第n个元素。如果n为负数，则返回从数组结尾开始的第n个元素。
 * @since 1.0.0
 * @param array (Array): 要查询的数组。
 * @param [n=0]  (number): 要返回元素的索引值。
 * @returns (*): 获取array数组的第n个元素。
 * @example
 * var array = ['a', 'b', 'c', 'd'];
 *
 * _.nth(array, 1);
 * // => 'b'
 *
 * _.nth(array, -2);
 * // => 'c';
 */
function nth(array, n) {
    if (n === void 0) { n = 0; }
    if ((0, isNil_1.default)(array) || array.length === 0) {
        return undefined;
    }
    var idx = n;
    if (!(0, isInteger_1.default)(n)) {
        idx = Number.parseInt(n.toString(), 10);
    }
    if ((0, isNaN_1.default)(idx)) {
        return undefined;
    }
    var arrLen = array.length;
    if (idx < 0) {
        idx = idx + arrLen;
    }
    return array[idx];
}
exports.default = nth;
