"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toString_1 = __importDefault(require("./toString"));
var words_1 = __importDefault(require("./words"));
/**
 * 将字符串转换成蛇形命名规则 [snake case](https://en.wikipedia.org/wiki/Snake_case).
 * @since 1.0.0
 * @Catalog String
 * @param [str=''] (string): 待转的字符
 * @returns (string): 蛇形命名规则字符，例如 `foo_bar`
 * @example
 * _.snakeCase('Foo Bar');
 * // => 'foo_bar'
 *
 * _.snakeCase('fooBar');
 * // => 'foo_bar'
 *
 * _.snakeCase('--FOO-BAR--');
 * // => 'foo_bar'
 *
 */
function snakeCase(str) {
    if (str === void 0) { str = ''; }
    if ((0, isNil_1.default)(str)) {
        return str;
    }
    var strValue = str;
    if (typeof str !== 'string') {
        strValue = (0, toString_1.default)(str);
    }
    return (0, words_1.default)(strValue.replace(/['\u2019]/g, '')).reduce(function (pv, cv, idx) {
        return pv + (idx ? '_' : '') + cv.toLowerCase();
    }, '');
}
exports.default = snakeCase;
