/**
 * 根据集合中的对象进行执行，返回一个值。
 * 如果 IterateFunc 类型为 string | object，则会根据object为key，找对象对应的值。
 */
declare type Iterate = ((value: any) => any) | string | object;
/**
 * 对指定集合内容进行升序（ASC）排序，并返回排序的数组。
 * 关于迭代器：
 * 排序的值则是来自 iteratees 来遍历对象生成的值，如果迭代器是一个对象或者字符串，则会以这个对象或者字符串为key，找到集合对象中的值。
 * 如果迭代器为函数或者函数集合，则该函数会接受集合对象中的每个对象，并且返回自定义的值；多个函数则意味着排序时按照多个值排序。
 * @param collection 计算排序的集合
 * @param iteratees 迭代器，默认不传入的时候，使用的是 value => value 函数替代。
 */
export default function sortBy(collection: any[] | Object, ...iteratees: Iterate[]): any[];
export {};
