import { TemplateSettings } from './templateSettings';
export interface TemplateOptions extends TemplateSettings {
    /**
     * 用于 debug 的 sourceURL 信息
     */
    sourceURL?: string;
}
/**
 * 模板字符串方法，支持
 * 1. 字符转义
 * 2. 插值方法
 * 3. 字符串解析
 *
 * @export
 * @param {string} [inputTemplate]
 * @param {(TemplateOptions | any)} [options]
 * @param {Record<string, any>} [guard]
 * @returns
 */
export default function template(inputTemplate?: string, options?: TemplateOptions | any, guard?: Record<string, any>): any;
