"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var templateSettings_1 = __importDefault(require("./templateSettings"));
var toString_1 = __importDefault(require("./toString"));
var defaultInterpolate_1 = __importDefault(require("./common/defaultInterpolate"));
var merge_1 = __importDefault(require("./merge"));
var INVALID_TEMPLATE_VARIABLE_ERROR = 'Invalid `variable` settings for template function';
var EMPTY_STRING_LEADING = /\b__p \+= '';/g;
var EMPTY_STRING_MIDDLE = /\b(__p \+=) '' \+/g;
var EMPTY_STRING_TRAILING = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
var ILLEGAL_IDENTIFIERS = /[()=,{}[\]/\s]/;
var ES6_TEMPLATE = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
var NOT_MATCH = /($^)/;
var UNESCAPE_STRING = /['\n\r\u2028\u2029\\]/g;
var ESCAPE_STRING = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\u2028': 'u2028',
    '\u2029': 'u2029',
};
function escapeStringChar(chr) {
    return "\\".concat(ESCAPE_STRING[chr]);
}
var hasOwnProperty = Object.prototype.hasOwnProperty;
/**
 * 模板字符串方法，支持
 * 1. 字符转义
 * 2. 插值方法
 * 3. 字符串解析
 *
 * @export
 * @param {string} [inputTemplate]
 * @param {(TemplateOptions | any)} [options]
 * @param {Record<string, any>} [guard]
 * @returns
 */
function template(inputTemplate, options, guard) {
    var settings = templateSettings_1.default.imports._.templateSettings || templateSettings_1.default;
    var passedOption = options;
    if (guard && guard[passedOption] === inputTemplate) {
        passedOption = undefined;
    }
    var templateString = (0, toString_1.default)(inputTemplate);
    var mergedOptions = (0, merge_1.default)({}, settings, passedOption);
    var imports = mergedOptions.imports;
    // 用于生成调试信息
    var sourceURL = hasOwnProperty.call(mergedOptions, 'sourceURL')
        ? "//# sourceURL=".concat("".concat(mergedOptions.sourceURL).replace(/\s/g, ' '), "\n")
        : '';
    var source = buildTemplateFunctionSource({
        templateString: templateString,
        mergedOptions: mergedOptions,
    });
    var result;
    try {
        var templateFunction_1 = Function("".concat(sourceURL, "return ").concat(source))();
        result = function (context) {
            if (context === void 0) { context = {}; }
            var externalObj = __assign(__assign({}, imports), context);
            return templateFunction_1 === null || templateFunction_1 === void 0 ? void 0 : templateFunction_1.call(this, externalObj);
        };
    }
    catch (e) {
        result = e;
    }
    result.source = source;
    if (result instanceof Error) {
        throw result;
    }
    return result;
}
exports.default = template;
/**
 * 构造模板方法字符串
 *
 * @param params 模板方法所需配置信息
 * @returns
 */
function buildTemplateFunctionSource(params) {
    var templateString = params.templateString, mergedOptions = params.mergedOptions;
    var variable = mergedOptions.variable || 'obj';
    if (ILLEGAL_IDENTIFIERS.test(variable)) {
        throw new Error(INVALID_TEMPLATE_VARIABLE_ERROR);
    }
    var interpolate = mergedOptions.interpolate || NOT_MATCH;
    var isEvaluating;
    var isEscaping;
    var index = 0;
    var source = "__p += '";
    var allDelimiters = RegExp("".concat((mergedOptions.escape || NOT_MATCH).source, "|").concat(interpolate.source, "|").concat((interpolate === defaultInterpolate_1.default ? ES6_TEMPLATE : NOT_MATCH).source, "|").concat((mergedOptions.evaluate || NOT_MATCH).source, "|$"), 'g');
    templateString.replace(allDelimiters, function (match, escapeValue, interpolatedValue, esTemplateValue, evaluateValue, offset) {
        var interpolateValue = interpolatedValue || esTemplateValue;
        source += templateString
            .slice(index, offset)
            .replace(UNESCAPE_STRING, escapeStringChar);
        if (escapeValue) {
            isEscaping = true;
            source += "' +\n__e(".concat(escapeValue, ") +\n'");
        }
        if (evaluateValue) {
            isEvaluating = true;
            source += "';\n".concat(evaluateValue, ";\n__p += '");
        }
        if (interpolateValue) {
            source += "' +\n((__t = (".concat(interpolateValue, ")) == null ? '' : __t) +\n'");
        }
        index = offset + match.length;
        return match;
    });
    source += "';\n";
    source = (isEvaluating ? source.replace(EMPTY_STRING_LEADING, '') : source)
        .replace(EMPTY_STRING_MIDDLE, '$1')
        .replace(EMPTY_STRING_TRAILING, '$1;');
    source = "function (".concat(variable, " = {}) {\nlet __t, __p = '' , _ = ").concat(variable, "['_']\n  ").concat(isEscaping ? ', __e = _.escape' : '').concat(isEvaluating
        ? ", __join = Array.prototype.join;\nfunction print() { __p += __join.call(arguments, '') }\n"
        : '', ";with(").concat(variable, "){\n").concat(source, "}\nreturn __p\n}");
    return source;
}
