"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var validCheck_1 = require("./common/validCheck");
var isSymbol_1 = __importDefault(require("./isSymbol"));
var trim_1 = __importDefault(require("./trim"));
/**
 * 处理二进制、八进制、十六进制的转换, 返回转换后的数字
 * @param input
 */
function decimalConversion(input) {
    var value = (0, trim_1.default)(input);
    var regexBinary = /^0b[01]+$/i;
    var regexOctal = /^0o[0-7]+$/i;
    var regexHex = /^[-+]0x[0-9a-f]+$/i;
    var isBinary = regexBinary.test(value);
    var isOctal = regexOctal.test(value);
    var isInvalidHec = regexHex.test(value);
    if (isBinary || isOctal) {
        return parseInt(value.slice(2), isBinary ? 2 : 8);
    }
    return isInvalidHec ? NaN : +value;
}
/**
 * 用于将给定的值转换为数字
 * @param input
 */
function toNumber(input) {
    var value = input;
    if (typeof value === 'number') {
        return value;
    }
    if ((0, isSymbol_1.default)(value)) {
        return NaN;
    }
    if ((0, validCheck_1.isObject)(value)) {
        var other = typeof value.valueOf === 'function' ? value.valueOf() : value;
        value = (0, validCheck_1.isObject)(other) ? "".concat(other) : other;
    }
    if (typeof value !== 'string') {
        return value === 0 ? value : +value;
    }
    return decimalConversion(value);
}
exports.default = toNumber;
