"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var toUpperCase = String ? String.prototype.toUpperCase : undefined;
/**
 * 转换整个string字符串的字符为大写
 * @param str (string) 待转换的字符串
 * @example
 * _.toUpper('--foo-bar--');
 * // => '--FOO-BAR--'
 *
 * _.toUpper('fooBar');
 * // => 'FOOBAR'
 *
 * _.toUpper('__foo_bar__');
 * // => '__FOO_BAR__'
 */
function toUpper(input) {
    if ((0, isNil_1.default)(input)) {
        return input;
    }
    return toUpperCase.call(input);
}
exports.default = toUpper;
