"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var validCheck_1 = require("./common/validCheck");
var stringToPaths_1 = require("./common/stringToPaths");
/**
 * 根据update函数和customizer函数更新obj对象中由rawPath路径指定的各个属性的值
 * @param obj，要更新的对象
 * @param rawPath，要更新的属性在obj中的路径
 * @param updater，一个函数，其返回值为rawPath中最后一层属性要更新的值
 * @param customizer，一个函数，其返回值作为rawPath中每一层（除了最后一层）属性要更新的值
 */
function updateWith(obj, rawPath, updater, customizer) {
    if (obj === undefined || obj === null) {
        return obj;
    }
    var path = (0, stringToPaths_1.getObjValidPathFromGeneralPath)(obj, rawPath);
    if (path.length === 0) {
        return obj;
    }
    var tmpObj = obj;
    for (var i = 0; i < path.length - 1; i++) {
        if (typeof tmpObj !== 'object') { // 对非object变量设置属性和值没有意义，故直接return
            return obj;
        }
        var attribute = path[i];
        var tmpValue = tmpObj[attribute];
        var customizedValue = typeof customizer === 'function' // 将customizer函数的返回值作为这层属性要更新的值
            ? customizer(tmpValue, attribute, tmpObj) : undefined;
        if (customizedValue === undefined || customizedValue === null) {
            /*
             * 遇见undefined或者null，要么使用原obj的值，如果原值也是undefined或者null,需要判断下一层属性
             * 如果下一层属性可以作为数组下标，那么customizedValue设置为[]，否则为{}
             */
            if (tmpValue === undefined || tmpValue === null) {
                customizedValue = (0, validCheck_1.isIndex)(path[i + 1]) ? [] : {};
            }
            else {
                customizedValue = tmpValue;
            }
        }
        tmpObj[attribute] = customizedValue; // 将这层属性的值更新为customizedValue
        tmpObj = customizedValue;
    }
    if (typeof tmpObj !== 'object') {
        return obj;
    }
    var lastAttribute = path[path.length - 1];
    var lastValue = typeof updater === 'function'
        ? updater(tmpObj[lastAttribute]) : undefined; // 将update函数返回值作为最后一层属性要更新的值
    tmpObj[lastAttribute] = lastValue;
    return obj;
}
exports.default = updateWith;
