export declare type Key = string | number | Symbol | undefined | null;
/**
 * 将 keys 和 values 按索引顺序拼接为 key-value 键值对
 *
 * @export
 * @param {Key[]} [keys=[]] 键数组
 * @param {any[]} [values=[]] 值数组
 * @returns 拼接的key-value 键值对
 * @example
 *
 * zipObject(['a', 'b'], [1, 2])
 * // => { 'a': 1, 'b': 2 }
 */
export default function zipObject(keys?: Array<Key>, values?: any[]): Object;
