"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAssignFunction = void 0;
var validCheck_1 = require("./common/validCheck");
var copyObject_1 = require("./common/copyObject");
var assignUtil_1 = require("./common/assignUtil");
var keys_1 = __importDefault(require("./keys"));
function createAssignFunction(assigner) {
    return function (object) {
        var sources = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sources[_i - 1] = arguments[_i];
        }
        var index = -1;
        var length = sources.length;
        var customizer = length > 1 ? sources[length - 1] : undefined;
        var guard = length > 2 ? sources[2] : undefined;
        customizer = (assigner.length > 3 && typeof customizer === 'function')
            ? (length--, customizer)
            : undefined;
        if (guard && (0, validCheck_1.isIterate)(sources[0], sources[1], guard)) {
            customizer = length < 3 ? undefined : customizer;
            length = 1;
        }
        var obj = Object(object);
        while (++index < length) {
            var source = sources[index];
            if (source) {
                assigner(obj, source, index, customizer);
            }
        }
        return obj;
    };
}
exports.createAssignFunction = createAssignFunction;
var assignRun = function (object, source) {
    if ((0, validCheck_1.isPrototype)(source) || Array.isArray(source)) {
        (0, copyObject_1.copyObject)(source, (0, keys_1.default)(source), object, undefined);
        return;
    }
    for (var key in source) {
        if (Object.hasOwnProperty.call(source, key)) {
            (0, assignUtil_1.assignValue)(object, key, source[key]);
        }
    }
};
/**
 * 分配来源对象的可枚举属性到目标对象上。 来源对象的应用规则是从左到右，随后的下一个对象的属性会覆盖上一个对象的属性。
 *
 * **注意**： 这方法会改变 object，参考自 [Object.assign](https://mdn.io/Object/assign)
 *
 * @public
 * @since 1.0.0
 * @param object (Object): 目标对象
 * @param sources (...Object): 来源对象。
 * @returns (Object): 返回 object.
 * @example
 * ```
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * function Bar() {
 *   this.c = 3;
 * }
 *
 * Foo.prototype.b = 2;
 * Bar.prototype.d = 4;
 *
 * _.assign({ 'a': 0 }, new Foo, new Bar);
 * // => { 'a': 1, 'c': 3 }
 * ```
 */
function assign(object) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    var assignFunction = createAssignFunction(assignRun);
    return assignFunction.apply(void 0, __spreadArray([object], __read(sources), false));
}
exports.default = assign;
