"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var upperFirst_1 = __importDefault(require("./upperFirst"));
var toString_1 = __importDefault(require("./toString"));
/**
 * 将字符串的首字符转换为大写格式，其他字符转换为小写格式
 *
 * @export
 * @param {string} text 要处理的字符串
 * @returns {string} Capitalize 后的字符串
 * @example
 *
 * capitalize('CAPITALIZE')
 * // => 'Capitalize'
 */
function capitalize(text) {
    return (0, upperFirst_1.default)((0, toString_1.default)(text).toLowerCase());
}
exports.default = capitalize;
