"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dealWithObject = void 0;
var isArrayLike_1 = __importDefault(require("../isArrayLike"));
var keys_1 = __importDefault(require("../keys"));
function createBaseFor() {
    return function createBaseForR(obj, iteratee, keysFunc) {
        var index = -1;
        var iterable = Object(obj);
        var props = keysFunc(obj);
        var length = props.length;
        while (length--) {
            var key = props[++index];
            if (iteratee(iterable[key], key, iterable) === false) {
                break;
            }
        }
        return obj;
    };
}
var baseFor = createBaseFor();
function baseForOwn(obj, iteratee) {
    return obj && baseFor(obj, iteratee, keys_1.default);
}
function createBaseEach(eachFunc, fromRight) {
    return function createBaseEachR(collection, iteratee) {
        if (collection == null) {
            return collection;
        }
        if (!(0, isArrayLike_1.default)(collection)) {
            return eachFunc(collection, iteratee);
        }
        var length = collection.length;
        var index = fromRight ? length : -1;
        var iterable = Object(collection);
        while ((fromRight ? index-- : ++index < length)) {
            if (iteratee(iterable[index], index, iterable) === false) {
                break;
            }
        }
        return collection;
    };
}
var baseEach = createBaseEach(baseForOwn, false);
// 对象或者类数组类型的处理
function dealWithObject(collection, iteratee) {
    var index = -1;
    var result = (0, isArrayLike_1.default)(collection) ? Array(collection.length) : [];
    baseEach(collection, function (value, key, collectionInner) {
        result[++index] = iteratee(value, key, collectionInner);
    });
    return result;
}
exports.dealWithObject = dealWithObject;
