"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./common/utils");
var isObjectLike_1 = __importDefault(require("./isObjectLike"));
/**
 * 判断传入的值是否是日期，并返回判断结果。
 * 如果是日期则返回true，其他情况都返回false
 * @Catalog core
 * @param value {any} 待判断的值
 * @returns boolean
 */
function isDate(value) {
    return (0, isObjectLike_1.default)(value) && (0, utils_1.tagName)(value) === '[object Date]';
}
exports.default = isDate;
