"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Checks if value is classified as a Map object.
 *
 * @since 1.0.0
 *
 * @param value (*): The value to check.
 * @returns (boolean): Returns true if value is a map, else false.
 *
 * @example
 *
 * _.isMap(new Map);
 * // => true
 *
 * _.isMap(new WeakMap);
 * // => false
 *
 */
function isMap(value) {
    if (value === void 0) { value = undefined; }
    if (value == null) {
        return false;
    }
    return value instanceof Map;
}
exports.default = isMap;
