"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 遍历指定集合中每个元素，根据运算每个元素生成对应的key，得到key和元素的映射关系，如若生成重复的key值只取最后一个生成该key值的元素
 * 返回一个对象，包含上述映射关系中的key值和对应的元素
 * @param collection，要遍历的集合，如果是一个对象，则将对象的所有value组成一个集合
 * @param iterator，运算规则，集合中每个元素根据此运算规则得到key值
 * @return 一个对象，包含上述映射关系中的key值和对应的元素
 */
function keyBy(collection, iterator) {
    var e_1, _a;
    var list = []; // 真正需要遍历的集合
    if (Array.isArray(collection)) {
        list = collection;
    }
    else if (Object.prototype.toString.call(collection) === '[object Object]') {
        list = Object.keys(collection).map(function (key) { return collection[key]; });
    }
    var map = new Map(); // 保存集合元素和元素生成的key值
    var result = {}; // 最终要返回的对象
    list.forEach(function (ele) {
        // 根据iterator具体类型，以对应方式生成ele的key
        var key = '';
        if (typeof iterator === 'function') {
            key = iterator(ele);
        }
        else if (iterator === undefined || iterator === null) {
            key = ele;
        }
        else if (typeof iterator === 'string' || typeof iterator === 'number') {
            key = ele[iterator];
        }
        if (String(key)) {
            map.set(String(key), ele);
        }
    });
    try {
        for (var _b = __values(map.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            result[key] = map.get(key);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
exports.default = keyBy;
