"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseArraySort_1 = require("./common/baseArraySort");
/**
 * 对指定的集合中的数据进行排序，并且返回一个新的数组。
 * 可以指定排序的字段，以及排序的方式（asc | desc）。
 * 此方法执行后，不影响原始 collection 中的顺序。
 * @Catalog Lang
 * @param collection 遍历排序的对象集合
 * @param iterate 排序的字段或者对象，支持多字段进行排序
 * @param orders 排序规则 （asc | desc）
 * @example
 * const users = [
 *   { 'user': 'fred',   'age': 48 },
 *   { 'user': 'barney', 'age': 34 },
 *   { 'user': 'fred',   'age': 40 },
 *   { 'user': 'barney', 'age': 36 }
 * ]
 *
 * // Sort by `user` in ascending order and by `age` in descending order.
 * orderBy(users, ['user', 'age'], ['asc', 'desc'])
 * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
 *
 * // Sort by `user` then by `age` using custom compare functions for each
 * orderBy(users, ['user', 'age'], [
 *   (a, b) => a.localeCompare(b, 'de', { sensitivity: 'base' }),
 *   (a, b) => a - b,
 * ])
 */
function orderBy(collection, iterate, orders) {
    if (collection == null) {
        return [];
    }
    // 参数清理
    var it;
    if (!Array.isArray(iterate)) {
        it = [iterate];
    }
    else {
        it = iterate;
    }
    var ods;
    if (!Array.isArray(orders)) {
        ods = orders == null ? [] : [orders];
    }
    else {
        ods = orders;
    }
    return sortBy(collection, it, ods);
}
exports.default = orderBy;
function objectSort(collection, its, ods) {
    var e_1, _a;
    var tmpResult = [];
    var keys = Object.keys(collection);
    try {
        for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
            var key = keys_1_1.value;
            tmpResult.push(collection[key]);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return (0, baseArraySort_1.arraySort)(tmpResult, its, ods);
}
function sortBy(collection, its, ods) {
    if (Array.isArray(collection)) {
        var tmpResult = [].concat(collection);
        return (0, baseArraySort_1.arraySort)(tmpResult, its, ods);
    }
    return objectSort(collection, its, ods);
}
