"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var identity_1 = __importDefault(require("./identity"));
var getAllKeys_1 = __importDefault(require("./common/getAllKeys"));
/**
 * Creates an object composed of the `object` properties `predicate` returns
 * truthy for. The predicate is invoked with two arguments: (value, key).
 *
 * @since 1.0.0
 * @category Object
 * @param object
 * @param {Function} predicate The function invoked per property.
 * @returns {Object} Returns the new object.
 * @example
 *
 * const object = { 'a': 1, 'b': '2', 'c': 3 }
 *
 * pickBy(object, isNumber)
 * // => { 'a': 1, 'c': 3 }
 */
function pickBy(object, predicate) {
    var newObj = {};
    if (!object) {
        return {};
    }
    var keys = (0, getAllKeys_1.default)(object);
    var prototypeKey = (0, getAllKeys_1.default)(Object.getPrototypeOf(object)); // get keys from object prototype.
    keys.push.apply(// get keys from object prototype.
    keys, __spreadArray([], __read(prototypeKey), false));
    keys.forEach(function (key) {
        var res = predicate ? predicate(object[key], key, object) : (0, identity_1.default)(object[key]);
        if (res) {
            newObj[key] = object[key];
        }
    });
    return newObj;
}
exports.default = pickBy;
