"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var stringToPaths_1 = require("./common/stringToPaths");
/**
 * 根据属性路径取得obj中的值，如果过程中遇见函数则会先计算函数返回结果，并转而在该结果上继续根据剩余路径去取值
 * @param obj，属性路径所属的对象
 * @param rawPath，属性路径
 * @param defaultValue，默认返回值，如果在取值过程中遇见undefined则直接返回defaultValue。可以是一个函数，会转而将其执行结果作为返回值
 * @return，返回根据属性路径在obj上遍历后取得的值，如遇undefined则返回defaultValue或其执行结果
 */
function result(obj, rawPath, defaultValue) {
    var e_1, _a;
    if (rawPath === void 0) { rawPath = []; }
    var path = (0, stringToPaths_1.getObjValidPathFromGeneralPath)(obj, rawPath);
    var tmpObj = obj;
    var tmpResult;
    try {
        for (var path_1 = __values(path), path_1_1 = path_1.next(); !path_1_1.done; path_1_1 = path_1.next()) {
            var attri = path_1_1.value;
            tmpResult = tmpObj[attri];
            if (typeof tmpResult === 'function') {
                tmpResult = tmpResult.call(tmpObj);
            }
            if (tmpResult === undefined || tmpResult === null) {
                break;
            }
            tmpObj = tmpResult;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (path_1_1 && !path_1_1.done && (_a = path_1.return)) _a.call(path_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (tmpResult === undefined || tmpResult === null) {
        return typeof defaultValue === 'function' ? defaultValue.call(tmpObj) : defaultValue;
    }
    return tmpResult;
}
exports.default = result;
