"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023. All rights reserved.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var toNumber_1 = __importDefault(require("./toNumber"));
var isNaN_1 = __importDefault(require("./isNaN"));
var INFINITY = 1 / 0;
var MAX_INTEGER = Number.MAX_VALUE;
/**
 * 将`value`转换为有限数。
 *
 * @since 1.0.0
 * @category Lang
 * @param {*} value 待转换的值
 * @returns {number} 转换之后的数字
 * @example
 *```
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 * ```
 */
function toFinite(value) {
    if (!value) {
        return value === 0 ? value : 0;
    }
    // 只处理无穷大正数和无穷小负数
    var result = (0, toNumber_1.default)(value);
    if (result === INFINITY || result === -INFINITY) {
        var sign = (result < 0 ? -1 : 1);
        return sign * MAX_INTEGER;
    }
    return !(0, isNaN_1.default)(result) ? result : 0;
}
exports.default = toFinite;
