"use strict";
/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildInstrument = void 0;
const instrument_1 = require("../instrument");
/**
 * 测试框架代码覆盖率收集代码插装插装 (编译构建调用)
 * @param projectConfig
 */
const buildInstrument = () => {
    return {
        name: 'buildInstrument',
        buildStart: buildStart,
        transform: transform,
        shouldInvalidCache: shouldInvalidCache,
    };
};
exports.buildInstrument = buildInstrument;
let flag;
/**
 * 功能：
 * @param {any} this
 */
async function buildStart() {
    const cacheNeedCoverageInsert = this.cache.get('needCoverageInsert');
    flag =
        cacheNeedCoverageInsert !== this.share.projectConfig.needCoverageInsert;
    this.cache.set('needCoverageInsert', this.share.projectConfig.needCoverageInsert);
}
/**
 * 功能：
 * @param {any} this
 * @param {string} code
 * @param {string} id
 * @returns
 */
async function transform(code, id) {
    // 忽略虚拟文件
    if (id.startsWith('\0')) {
        return;
    }
    if (!this.share.projectConfig.needCoverageInsert) {
        return;
    }
    const modulePath = this.share.projectConfig.modulePath;
    const sourceMap = this.getCombinedSourcemap();
    if (sourceMap === undefined) {
        return;
    }
    const sourceFilePath = sourceMap.sources[0];
    if (sourceFilePath === undefined) {
        return;
    }
    const projectPath = this.share.projectConfig.projectTopDir;
    let testFrameworkParam = this.share.projectConfig.testFrameworkPar;
    code = await (0, instrument_1.instrument)(projectPath, modulePath, code, sourceMap, testFrameworkParam);
    return {
        code: code,
        map: sourceMap,
    };
}
async function shouldInvalidCache() {
    return flag;
}
