export interface startEnd {
    start: {
        line: number;
        column: number;
    };
    end: {
        line: number;
        column: number;
    };
}
export interface statementMap {
    [key: string]: startEnd;
}
export interface fnMap {
    [key: string]: {
        loc: startEnd;
        decl: startEnd;
        line: number;
        name: string;
    };
}
export interface funMapNode {
    loc: startEnd;
    decl: startEnd;
    line: number;
    name: string;
}
export interface branchMap {
    [key: string]: {
        loc: startEnd;
        line: number;
        locations: startEnd[];
        type: string;
    };
}
export interface inputSourceMap {
    mappings: string;
    file: string | null;
    names: string[];
    sources: string[];
    sourcesContent: string[];
    version: number;
}
export interface coverageMap {
    [key: string]: commonCoverageMap;
}
export interface commonCoverageMap {
    path: string;
    statementMap: statementMap;
    b: {
        [key: string]: number[];
    };
    s: {
        [key: string]: number;
    };
    fnMap: fnMap;
    f: {
        [key: string]: number;
    };
    branchMap: branchMap;
    inputSourceMap: inputSourceMap;
    _coverageSchema: string;
    hash: string;
}
