/**
 * 实现了自定义对象在Map中作为key的唯一性
 */
export declare class ObjectUniqueMap<K extends Equals<any>, V> extends Map {
    get(key: K): V | undefined;
    has(key: K): boolean;
}
/**
 * 比较两个对象是否相等，当需要在Map中让自定义对象作为key并保证唯一时，实现这个接口并配合ObjectUniqueMap使用
 */
export interface Equals<T> {
    equals(other: T): boolean;
}
